"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _form_row = require("./form_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/input_control_vis/public/components/vis/list_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ListControlUi extends _react.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isLoading: false
    });
    (0, _defineProperty2.default)(this, "textInput", void 0);
    (0, _defineProperty2.default)(this, "componentDidMount", () => {
      if (this.textInput) {
        this.textInput.setAttribute('focusable', 'false'); // remove when #59039 is fixed
      }
      this.isMounted = true;
    });
    (0, _defineProperty2.default)(this, "componentWillUnmount", () => {
      this.isMounted = false;
    });
    (0, _defineProperty2.default)(this, "setTextInputRef", ref => {
      this.textInput = ref;
    });
    (0, _defineProperty2.default)(this, "handleOnChange", selectedOptions => {
      const selectedValues = selectedOptions.map(({
        value
      }) => {
        return value;
      });
      this.props.stageFilter(this.props.controlIndex, selectedValues);
    });
    (0, _defineProperty2.default)(this, "debouncedFetch", _lodash.default.debounce(async searchValue => {
      if (this.props.fetchOptions) {
        await this.props.fetchOptions(searchValue);
      }
      if (this.isMounted) {
        this.setState({
          isLoading: false
        });
      }
    }, 300));
    (0, _defineProperty2.default)(this, "onSearchChange", searchValue => {
      this.setState({
        isLoading: true
      }, this.debouncedFetch.bind(null, searchValue));
    });
    this.textInput = null;
  }
  renderControl() {
    var _this$props$options;
    const {
      intl
    } = this.props;
    if (this.props.disableMsg) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "aria-label": intl.formatMessage({
          id: 'inputControl.vis.listControl.selectTextPlaceholder',
          defaultMessage: 'Select...'
        }),
        placeholder: intl.formatMessage({
          id: 'inputControl.vis.listControl.selectTextPlaceholder',
          defaultMessage: 'Select...'
        }),
        disabled: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 9
        }
      });
    }
    const options = (_this$props$options = this.props.options) === null || _this$props$options === void 0 ? void 0 : _this$props$options.map(option => {
      return {
        label: this.props.formatOptionLabel(option).toString(),
        value: option,
        ['data-test-subj']: `option_${option.toString().replace(' ', '_')}`
      };
    }).sort((a, b) => {
      return a.label.toLowerCase().localeCompare(b.label.toLowerCase());
    });
    const selectedOptions = this.props.selectedOptions.map(selectedOption => {
      return {
        label: this.props.formatOptionLabel(selectedOption).toString(),
        value: selectedOption
      };
    });
    const selectPlaceholderLabel = intl.formatMessage({
      id: 'inputControl.vis.listControl.selectPlaceholder',
      defaultMessage: 'Select...'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: selectPlaceholderLabel,
      "aria-label": selectPlaceholderLabel,
      options: options,
      isLoading: this.state.isLoading,
      async: this.props.dynamicOptions,
      onSearchChange: this.props.dynamicOptions ? this.onSearchChange : undefined,
      selectedOptions: selectedOptions,
      onChange: this.handleOnChange,
      singleSelection: !this.props.multiselect,
      "data-test-subj": `listControlSelect${this.props.controlIndex}`,
      inputRef: this.setTextInputRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 7
      }
    });
  }
  render() {
    const partialResultsWarningMessage = _i18n.i18n.translate('inputControl.vis.listControl.partialResultsWarningMessage', {
      defaultMessage: 'Terms list might be incomplete because the request is taking too long. ' + 'Adjust the autocomplete settings in kibana.yml for complete results.'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
      colorMode: this.props.isDarkMode ? 'dark' : 'light',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
      id: this.props.id,
      label: this.props.label,
      warningMsg: this.props.partialResults ? partialResultsWarningMessage : undefined,
      controlIndex: this.props.controlIndex,
      disableMsg: this.props.disableMsg,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 9
      }
    }, this.renderControl()));
  }
}
(0, _defineProperty2.default)(ListControlUi, "defaultProps", {
  dynamicOptions: false,
  multiselect: true,
  selectedOptions: [],
  options: []
});
const ListControl = exports.ListControl = (0, _i18nReact.injectI18n)(ListControlUi);