"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreeNode = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _pipeline_processors_editor_item = require("../../pipeline_processors_editor_item");
var _add_processor_button = require("../../add_processor_button");
var _private_tree = require("./private_tree");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processors_tree/components/tree_node.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INDENTATION_PX = 34;
const useStyles = ({
  level
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    container: (0, _react2.css)`
      margin-top: ${euiTheme.size.s};
      margin-bottom: ${euiTheme.size.s};
      margin-left: ${level * INDENTATION_PX}px;
      & > * {
        overflow: visible;
      }
    `
  };
};
const TreeNode = ({
  processor,
  processorInfo,
  onAction,
  movingProcessor,
  level
}) => {
  const stringSelector = (0, _react.useMemo)(() => processorInfo.selector.join('.'), [processorInfo.selector]);
  const styles = useStyles({
    level
  });
  const buttonRef = (0, _react.useRef)(null);
  const handlers = (0, _react.useMemo)(() => {
    return {
      onMove: () => {
        onAction({
          type: 'selectToMove',
          payload: {
            info: processorInfo
          }
        });
      },
      onCancelMove: () => {
        onAction({
          type: 'cancelMove'
        });
      }
    };
  }, [onAction, stringSelector, processor]); // eslint-disable-line react-hooks/exhaustive-deps

  const renderOnFailureHandlersTree = (0, _react.useCallback)(() => {
    var _processor$onFailure;
    if (!((_processor$onFailure = processor.onFailure) !== null && _processor$onFailure !== void 0 && _processor$onFailure.length)) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      css: styles.container,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.onFailureProcessorsLabel', {
      defaultMessage: 'Failure handlers'
    })), /*#__PURE__*/_react.default.createElement(_private_tree.PrivateTree, {
      level: level + 1,
      movingProcessor: movingProcessor,
      onAction: onAction,
      selector: processorInfo.selector.concat('onFailure'),
      processors: processor.onFailure,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_add_processor_button.AddProcessorButton, {
      ref: buttonRef,
      "data-test-subj": stringSelector,
      renderButtonAsLink: true,
      onClick: () => onAction({
        type: 'addProcessor',
        payload: {
          target: processorInfo.selector.concat('onFailure'),
          buttonRef
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }));
  }, [processor.onFailure, stringSelector, onAction, movingProcessor, level]); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/_react.default.createElement(_pipeline_processors_editor_item.PipelineProcessorsEditorItem, {
    movingProcessor: movingProcessor,
    selector: processorInfo.selector,
    processor: processor,
    handlers: handlers,
    description: processor.options.description,
    renderOnFailureHandlers: renderOnFailureHandlersTree,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  });
};
exports.TreeNode = TreeNode;