"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivateTree = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _AutoSizer = _interopRequireDefault(require("react-virtualized/dist/commonjs/AutoSizer"));
var _List = _interopRequireDefault(require("react-virtualized/dist/commonjs/List"));
var _WindowScroller = _interopRequireDefault(require("react-virtualized/dist/commonjs/WindowScroller"));
var _constants = require("../../../constants");
var _processors_reducer = require("../../../processors_reducer");
var _utils = require("../../../utils");
var _2 = require(".");
var _utils2 = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processors_tree/components/private_tree.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isDropZoneAboveDisabled = (processor, selectedProcessor) => {
  return Boolean(
  // Is the selected node first in a list?
  !selectedProcessor.aboveId && selectedProcessor.id === processor.id || (0, _processors_reducer.isChildPath)(selectedProcessor.selector, processor.selector));
};
const isDropZoneBelowDisabled = (processor, selectedProcessor) => {
  return processor.id === selectedProcessor.id || processor.belowId === selectedProcessor.id || (0, _processors_reducer.isChildPath)(selectedProcessor.selector, processor.selector);
};

/**
 * Recursively rendering tree component for ingest pipeline processors.
 *
 * Note: this tree should start at level 1. It is the only level at
 * which we render the optimised virtual component. This gives a
 * massive performance boost to this component which can get very tall.
 *
 * The first level list also contains the outside click listener which
 * enables users to click outside of the tree and cancel moving a
 * processor.
 */
const PrivateTree = ({
  processors,
  selector,
  movingProcessor,
  onAction,
  level,
  windowScrollerRef,
  listRef
}) => {
  const selectors = (0, _react.useMemo)(() => {
    return processors.map((_, idx) => selector.concat(String(idx)));
  }, [processors, selector]);
  const renderRow = ({
    idx,
    info,
    processor
  }) => {
    const stringifiedSelector = (0, _utils.selectorToDataTestSubject)(info.selector);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, idx === 0 ? /*#__PURE__*/_react.default.createElement(_2.DropZoneButton, {
      "data-test-subj": `dropButtonAbove-${stringifiedSelector}`,
      onClick: event => {
        event.preventDefault();
        onAction({
          type: 'move',
          payload: {
            destination: selector.concat(_constants.DropSpecialLocations.top),
            source: movingProcessor.selector
          }
        });
      },
      isVisible: Boolean(movingProcessor),
      isDisabled: !movingProcessor || isDropZoneAboveDisabled(info, movingProcessor),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    }) : undefined, /*#__PURE__*/_react.default.createElement(_2.TreeNode, {
      level: level,
      processor: processor,
      processorInfo: info,
      onAction: onAction,
      movingProcessor: movingProcessor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_2.DropZoneButton, {
      compressed: level === 1 && idx + 1 === processors.length,
      "data-test-subj": `dropButtonBelow-${stringifiedSelector}`,
      isVisible: Boolean(movingProcessor),
      isDisabled: !movingProcessor || isDropZoneBelowDisabled(info, movingProcessor),
      onClick: event => {
        event.preventDefault();
        onAction({
          type: 'move',
          payload: {
            destination: selector.concat(String(idx + 1)),
            source: movingProcessor.selector
          }
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }));
  };
  (0, _react.useEffect)(() => {
    if (windowScrollerRef && windowScrollerRef.current) {
      windowScrollerRef.current.updatePosition();
    }
    if (listRef && listRef.current) {
      listRef.current.recomputeRowHeights();
    }
  }, [processors, listRef, windowScrollerRef, movingProcessor]);

  // A list optimized to handle very many items.
  const renderVirtualList = () => {
    return /*#__PURE__*/_react.default.createElement(_WindowScroller.default, {
      ref: windowScrollerRef,
      scrollElement: window,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 7
      }
    }, ({
      height,
      registerChild,
      isScrolling,
      onChildScroll,
      scrollTop
    }) => {
      return /*#__PURE__*/_react.default.createElement(_AutoSizer.default, {
        disableHeight: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 13
        }
      }, ({
        width
      }) => {
        return /*#__PURE__*/_react.default.createElement("div", {
          style: {
            width: '100%'
          },
          ref: registerChild,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 150,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_List.default, {
          ref: listRef,
          autoHeight: true,
          height: height,
          width: width,
          overScanRowCount: 5,
          isScrolling: isScrolling,
          onChildScroll: onChildScroll,
          scrollTop: scrollTop,
          rowCount: processors.length,
          rowHeight: ({
            index
          }) => {
            const processor = processors[index];
            return (0, _utils2.calculateItemHeight)({
              processor,
              isFirstInArray: index === 0
            });
          },
          rowRenderer: ({
            index: idx,
            style
          }) => {
            const processor = processors[idx];
            const above = processors[idx - 1];
            const below = processors[idx + 1];
            const info = {
              id: processor.id,
              selector: selectors[idx],
              aboveId: above === null || above === void 0 ? void 0 : above.id,
              belowId: below === null || below === void 0 ? void 0 : below.id
            };
            return /*#__PURE__*/_react.default.createElement("div", {
              style: style,
              key: processor.id,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 180,
                columnNumber: 27
              }
            }, renderRow({
              processor,
              info,
              idx
            }));
          },
          processors: processors,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 151,
            columnNumber: 21
          }
        }));
      });
    });
  };
  if (level === 1) {
    // Only render the optimised list for the top level list because that is the list
    // that will almost certainly be the tallest
    return renderVirtualList();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 5
    }
  }, processors.map((processor, idx) => {
    const above = processors[idx - 1];
    const below = processors[idx + 1];
    const info = {
      id: processor.id,
      selector: selector.concat(String(idx)),
      aboveId: above === null || above === void 0 ? void 0 : above.id,
      belowId: below === null || below === void 0 ? void 0 : below.id
    };
    return /*#__PURE__*/_react.default.createElement("div", {
      key: processor.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 16
      }
    }, renderRow({
      processor,
      idx,
      info
    }));
  }));
};
exports.PrivateTree = PrivateTree;