"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricsFeature = void 0;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _server2 = require("@kbn/metrics-data-access-plugin/server");
var _common = require("@kbn/alerting-plugin/common");
var _metrics = require("../common/alerting/metrics");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricRuleTypes = [_metrics.METRIC_THRESHOLD_ALERT_TYPE_ID, _metrics.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID, _ruleDataUtils.ES_QUERY_ID, _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID, _ruleDataUtils.ML_ANOMALY_DETECTION_RULE_TYPE_ID];
const getMetricsFeature = () => {
  const metricAlertingFeatures = metricRuleTypes.map(ruleTypeId => {
    const consumers = [_constants.METRICS_FEATURE_ID, _common.ALERTING_FEATURE_ID, ..._ruleDataUtils.DEPRECATED_ALERTING_CONSUMERS];
    return {
      ruleTypeId,
      consumers
    };
  });
  const METRICS_FEATURE = {
    id: _constants.METRICS_FEATURE_ID,
    name: _i18n.i18n.translate('xpack.infra.featureRegistry.linkInfrastructureTitle', {
      defaultMessage: 'Infrastructure'
    }),
    order: 800,
    category: _server.DEFAULT_APP_CATEGORIES.observability,
    app: ['infra', 'metrics', 'kibana'],
    catalogue: ['infraops', 'metrics'],
    management: {
      insightsAndAlerting: ['triggersActions']
    },
    alerting: metricAlertingFeatures,
    privileges: {
      all: {
        app: ['infra', 'metrics', 'kibana'],
        catalogue: ['infraops', 'metrics'],
        api: ['infra', 'rac'],
        savedObject: {
          all: ['infrastructure-ui-source', _server2.metricsDataSourceSavedObjectName],
          read: ['index-pattern']
        },
        alerting: {
          rule: {
            all: metricAlertingFeatures
          },
          alert: {
            all: metricAlertingFeatures
          }
        },
        management: {
          insightsAndAlerting: ['triggersActions']
        },
        ui: ['show', 'configureSource', 'save']
      },
      read: {
        app: ['infra', 'metrics', 'kibana'],
        catalogue: ['infraops', 'metrics'],
        api: ['infra', 'rac'],
        savedObject: {
          all: [],
          read: ['infrastructure-ui-source', 'index-pattern', _server2.metricsDataSourceSavedObjectName]
        },
        alerting: {
          rule: {
            read: metricAlertingFeatures
          },
          alert: {
            read: metricAlertingFeatures
          }
        },
        management: {
          insightsAndAlerting: ['triggersActions']
        },
        ui: ['show']
      }
    }
  };
  return METRICS_FEATURE;
};
exports.getMetricsFeature = getMetricsFeature;