"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.infraAlertFeatureIds = exports.UNTRACKED_ALERTS = exports.RECOVERED_ALERTS = exports.ALL_ALERTS = exports.ALERT_STATUS_QUERY = exports.ALERT_STATUS_ALL = exports.ALERTS_TABLE_ID = exports.ALERTS_PER_PAGE = exports.ALERTS_PATH = exports.ALERTS_DOC_HREF = exports.ACTIVE_ALERTS = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_STATUS_ALL = exports.ALERT_STATUS_ALL = 'all';
const ALL_ALERTS = exports.ALL_ALERTS = {
  status: ALERT_STATUS_ALL,
  label: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.alertStatusFilter.showAll', {
    defaultMessage: 'Show all'
  })
};
const ACTIVE_ALERTS = exports.ACTIVE_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_ACTIVE,
  query: {
    term: {
      [_ruleDataUtils.ALERT_STATUS]: {
        value: _ruleDataUtils.ALERT_STATUS_ACTIVE
      }
    }
  },
  label: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.alertStatusFilter.active', {
    defaultMessage: 'Active'
  })
};
const RECOVERED_ALERTS = exports.RECOVERED_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_RECOVERED,
  query: {
    term: {
      [_ruleDataUtils.ALERT_STATUS]: {
        value: _ruleDataUtils.ALERT_STATUS_RECOVERED
      }
    }
  },
  label: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.alertStatusFilter.recovered', {
    defaultMessage: 'Recovered'
  })
};
const UNTRACKED_ALERTS = exports.UNTRACKED_ALERTS = {
  status: _ruleDataUtils.ALERT_STATUS_UNTRACKED,
  query: {
    term: {
      [_ruleDataUtils.ALERT_STATUS]: {
        value: _ruleDataUtils.ALERT_STATUS_UNTRACKED
      }
    }
  },
  label: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.alerts.alertStatusFilter.untracked', {
    defaultMessage: 'Untracked'
  })
};
const ALERT_STATUS_QUERY = exports.ALERT_STATUS_QUERY = {
  [ACTIVE_ALERTS.status]: ACTIVE_ALERTS.query,
  [RECOVERED_ALERTS.status]: RECOVERED_ALERTS.query,
  [UNTRACKED_ALERTS.status]: UNTRACKED_ALERTS.query
};
const ALERTS_DOC_HREF = exports.ALERTS_DOC_HREF = 'https://www.elastic.co/guide/en/observability/current/create-alerts.html';
const ALERTS_PATH = exports.ALERTS_PATH = '/app/observability/alerts';
const ALERTS_PER_PAGE = exports.ALERTS_PER_PAGE = 10;
const ALERTS_TABLE_ID = exports.ALERTS_TABLE_ID = 'xpack.infra.hosts.alerts.table';
const infraAlertFeatureIds = exports.infraAlertFeatureIds = _constants.INFRA_ALERT_CONSUMERS;