"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Metadata = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _table = require("./table");
var _utils = require("./utils");
var _use_metadata_state = require("../../hooks/use_metadata_state");
var _metadata_explanation = require("../../components/metadata_explanation");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_asset_details_url_state = require("../../hooks/use_asset_details_url_state");
var _metadata_error_callout = require("../../components/metadata_error_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/metadata/metadata.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Metadata = () => {
  var _overrides$metadata;
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    overrides,
    entity,
    schema
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metadata,
    loading: metadataLoading,
    error: fetchMetadataError
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    showActionsColumn = false
  } = (_overrides$metadata = overrides === null || overrides === void 0 ? void 0 : overrides.metadata) !== null && _overrides$metadata !== void 0 ? _overrides$metadata : {};
  const fields = (0, _react.useMemo)(() => (0, _utils.getAllFields)(metadata, schema), [metadata, schema]);
  const onSearchChange = (0, _react.useCallback)(newQuery => {
    setUrlState({
      metadataSearch: newQuery
    });
  }, [setUrlState]);
  if (fetchMetadataError && !metadataLoading) {
    return /*#__PURE__*/_react.default.createElement(_metadata_error_callout.MetadataErrorCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metadata_explanation.MetadataExplanationMessage, {
    entityType: entity.type,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_table.Table, {
    search: urlState === null || urlState === void 0 ? void 0 : urlState.metadataSearch,
    onSearchChange: onSearchChange,
    showActionsColumn: showActionsColumn,
    rows: fields,
    loading: metadataLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }));
};

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
exports.Metadata = Metadata;
var _default = exports.default = Metadata;