"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataExplanationMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _popover = require("../tabs/common/popover");
var _use_metadata_state = require("../hooks/use_metadata_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/components/metadata_explanation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DOCS_LINKS = {
  ecs_host: 'https://www.elastic.co/guide/en/ecs/current/ecs-host.html#field-host-name',
  ecs_container: 'https://www.elastic.co/guide/en/ecs/current/ecs-container.html#field-container-id',
  semconv_host: 'https://opentelemetry.io/docs/specs/semconv/registry/attributes/host/#host-name'
};
const MetadataExplanationTooltipContent = /*#__PURE__*/_react.default.memo(({
  docsLink,
  metadataField
}) => {
  const onClick = e => {
    e.stopPropagation();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    onClick: onClick,
    style: {
      width: 200
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.metadata.tooltip.documentationLabel",
    defaultMessage: "{metadata} is populated from the last event detected for this {metadataField} for the selected date period.",
    values: {
      metadata: /*#__PURE__*/_react.default.createElement("i", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.metadata.tooltip.metadata",
        defaultMessage: "Metadata",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 17
        }
      })),
      metadataField: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsTooltipDocumentationLink",
        href: docsLink,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.metadata.tooltip.documentationLink",
        defaultMessage: "{metadataField}",
        values: {
          metadataField
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }));
});
const MetadataExplanationMessage = ({
  entityType,
  schema
}) => {
  var _metadata$info, _metadata$info2, _metadata$info3;
  const {
    metadata,
    loading
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const docsLink = entityType === 'host' ? schema === 'semconv' ? DOCS_LINKS.semconv_host : DOCS_LINKS.ecs_host : DOCS_LINKS.ecs_container;
  const metadataField = (0, _common.findInventoryFields)(entityType).id;
  return loading && !metadata ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }) : metadata !== null && metadata !== void 0 && (_metadata$info = metadata.info) !== null && _metadata$info !== void 0 && _metadata$info.timestamp ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "baseline",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.metadata.tooltip.metadataSectionTitle",
    defaultMessage: "Showing metadata collected on {date} @ {time}",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: new Date(metadata === null || metadata === void 0 ? void 0 : (_metadata$info2 = metadata.info) === null || _metadata$info2 === void 0 ? void 0 : _metadata$info2.timestamp),
        month: "short",
        day: "numeric",
        year: "numeric",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 17
        }
      }),
      time: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: new Date(metadata === null || metadata === void 0 ? void 0 : (_metadata$info3 = metadata.info) === null || _metadata$info3 === void 0 ? void 0 : _metadata$info3.timestamp),
        hour12: false,
        hour: "2-digit",
        minute: "2-digit",
        second: "2-digit",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 17
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    iconSize: "s",
    iconColor: "subdued",
    icon: "info",
    "data-test-subj": "infraAssetDetailsMetadataPopoverButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(MetadataExplanationTooltipContent, {
    docsLink: docsLink,
    metadataField: metadataField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  })))) : null;
};
exports.MetadataExplanationMessage = MetadataExplanationMessage;