"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTemperatureIfValid = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPENAI_MODELS_WITHOUT_TEMPERATURE = ['o1', 'o3', 'gpt-5'];
const getTemperatureIfValid = (temperature, {
  connector,
  modelName
} = {}) => {
  var _ref, _connector$config, _connector$config$pro, _connector$config2;
  if (temperature === undefined) return {};
  const model = (_ref = modelName !== null && modelName !== void 0 ? modelName : connector === null || connector === void 0 ? void 0 : (_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : (_connector$config$pro = _connector$config.providerConfig) === null || _connector$config$pro === void 0 ? void 0 : _connector$config$pro.model_id) !== null && _ref !== void 0 ? _ref : connector === null || connector === void 0 ? void 0 : (_connector$config2 = connector.config) === null || _connector$config2 === void 0 ? void 0 : _connector$config2.defaultModel;
  if (((connector === null || connector === void 0 ? void 0 : connector.type) === _inferenceCommon.InferenceConnectorType.OpenAI || (connector === null || connector === void 0 ? void 0 : connector.type) === _inferenceCommon.InferenceConnectorType.Inference) && model) {
    const normalizedModelName = model.toLowerCase();
    const shouldExcludeTemperature = OPENAI_MODELS_WITHOUT_TEMPERATURE.some(
    //  e.g openai/gpt-5 or gpt-5-xxx
    m => normalizedModelName.startsWith(m) || normalizedModelName.endsWith(m));
    return shouldExcludeTemperature ? {} : {
      temperature
    };
  }
  return {
    temperature
  };
};
exports.getTemperatureIfValid = getTemperatureIfValid;