"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnonymizableMessageParts = getAnonymizableMessageParts;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * getAnonymizableMessageParts returns just the data of a
 * message that needs to be anonymized. This prevents us
 * from anonymizing things that should not be anonymized
 * because of technical dependencies, like `role` or
 * `toolCallId`.
 */
function getAnonymizableMessageParts(message) {
  if (message.role === _inferenceCommon.MessageRole.Tool) {
    return {
      response: message.response
    };
  }
  if (message.role === _inferenceCommon.MessageRole.Assistant) {
    var _message$toolCalls;
    return {
      content: message.content,
      toolCalls: (_message$toolCalls = message.toolCalls) === null || _message$toolCalls === void 0 ? void 0 : _message$toolCalls.map(toolCall => {
        return {
          function: toolCall.function
        };
      })
    };
  }
  return {
    content: message.content
  };
}