"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappingsEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _app_context = require("../../app_context");
var _components = require("./components");
var _mappings_state_context = require("./mappings_state_context");
var _use_state_listener = require("./use_state_listener");
var _config_context = require("./config_context");
var _document_fields_header = require("./components/document_fields/document_fields_header");
var _search_fields = require("./components/document_fields/search_fields");
var _parse_mappings = require("../../shared/parse_mappings");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/mappings_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MappingsEditor = exports.MappingsEditor = /*#__PURE__*/_react.default.memo(({
  onChange,
  value,
  docLinks,
  indexSettings,
  esNodesPlugins,
  indexMode
}) => {
  const {
    canUseSyntheticSource
  } = (0, _app_context.useAppContext)();
  const {
    parsedDefaultValue,
    multipleMappingsDeclared
  } = (0, _react.useMemo)(() => (0, _parse_mappings.parseMappings)(value), [value]);
  /**
   * Hook that will listen to:
   * 1. "value" prop changes in order to reset the mappings editor
   * 2. "state" changes in order to communicate any updates to the consumer
   */
  (0, _use_state_listener.useMappingsStateListener)({
    onChange,
    value: parsedDefaultValue
  });
  const {
    update: updateConfig
  } = (0, _config_context.useConfig)();
  const state = (0, _mappings_state_context.useMappingsState)();
  const [selectedTab, selectTab] = (0, _react.useState)('fields');
  (0, _react.useEffect)(() => {
    if (multipleMappingsDeclared) {
      // We set the data getter here as the user won't be able to make any changes
      onChange({
        getData: () => value,
        validate: () => Promise.resolve(true),
        isValid: true
      });
    }
  }, [multipleMappingsDeclared, onChange, value]);
  (0, _react.useEffect)(() => {
    // Update the the config context so it is available globally (e.g in our Global flyout)
    updateConfig({
      docLinks,
      indexSettings: indexSettings !== null && indexSettings !== void 0 ? indexSettings : {}
    });
  }, [updateConfig, docLinks, indexSettings]);
  const changeTab = async tab => {
    if (selectedTab === 'advanced') {
      // When we navigate away we need to submit the form to validate if there are any errors.
      const {
        isValid: isConfigurationFormValid
      } = await state.configuration.submitForm();
      if (!isConfigurationFormValid) {
        /**
         * Don't navigate away from the tab if there are errors in the form.
         */
        return;
      }
    } else if (selectedTab === 'templates') {
      const {
        isValid: isTemplatesFormValid
      } = await state.templates.submitForm();
      if (!isTemplatesFormValid) {
        return;
      }
    }
    selectTab(tab);
  };
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const onSearchChange = (0, _react.useCallback)(searchValue => {
    dispatch({
      type: 'search:update',
      value: searchValue
    });
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    if (!state.configuration.defaultValue._source && (indexMode === _constants.LOGSDB_INDEX_MODE || indexMode === _constants.TIME_SERIES_MODE)) {
      if (canUseSyntheticSource) {
        // If the source field is undefined (hasn't been set in the form)
        // and if the user has selected a `logsdb` or `time_series` index mode in the Logistics step,
        // update the form data with synthetic _source
        dispatch({
          type: 'configuration.save',
          value: {
            ...state.configuration.defaultValue,
            _source: {
              mode: 'synthetic'
            }
          }
        });
      }
    }
  }, [indexMode, dispatch, state.configuration, canUseSyntheticSource]);
  const tabToContentMap = {
    fields: /*#__PURE__*/_react.default.createElement(_components.DocumentFields, {
      searchComponent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_document_fields_header.DocumentFieldsHeader, {
        searchValue: state.search.term,
        onSearchChange: onSearchChange,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 15
        }
      })),
      searchResultComponent: state.search.term.trim() !== '' ? /*#__PURE__*/_react.default.createElement(_search_fields.SearchResult, {
        result: state.search.result,
        documentFieldsState: state.documentFields,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 15
        }
      }) : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 9
      }
    }),
    runtimeFields: /*#__PURE__*/_react.default.createElement(_components.RuntimeFieldsList, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 22
      }
    }),
    templates: /*#__PURE__*/_react.default.createElement(_components.TemplatesForm, {
      value: state.templates.defaultValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 18
      }
    }),
    advanced: /*#__PURE__*/_react.default.createElement(_components.ConfigurationForm, {
      value: state.configuration.defaultValue,
      esNodesPlugins: esNodesPlugins,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 9
      }
    })
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mappingsEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, multipleMappingsDeclared ? /*#__PURE__*/_react.default.createElement(_components.MultipleMappingsWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => changeTab('fields'),
    isSelected: selectedTab === 'fields',
    "data-test-subj": "formTab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fieldsTabLabel', {
    defaultMessage: 'Mapped fields'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => changeTab('runtimeFields'),
    isSelected: selectedTab === 'runtimeFields',
    "data-test-subj": "formTab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.runtimeFieldsTabLabel', {
    defaultMessage: 'Runtime fields'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => changeTab('templates'),
    isSelected: selectedTab === 'templates',
    "data-test-subj": "formTab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.templatesTabLabel', {
    defaultMessage: 'Dynamic templates'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => changeTab('advanced'),
    isSelected: selectedTab === 'advanced',
    "data-test-subj": "formTab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.advancedTabLabel', {
    defaultMessage: 'Advanced options'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }), tabToContentMap[selectedTab]));
});