"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsListItemContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mappings_state_context = require("../../../mappings_state_context");
var _fields_list_item = require("./fields_list_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/fields_list_item_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldsListItemContainer = ({
  fieldId,
  treeDepth,
  isLastItem,
  state,
  setPreviousState,
  isAddingFields,
  pendingFieldsRef
}) => {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const listElement = (0, _react.useRef)(null);
  const {
    documentFields: {
      status,
      fieldToAddFieldTo,
      fieldToEdit
    },
    fields: {
      byId,
      maxNestedDepth,
      rootLevelFields
    },
    runtimeFields
  } = state;
  const getField = (0, _react.useCallback)(id => byId[id], [byId]);
  const runtimeFieldNames = Object.values(runtimeFields).map(field => field.source.name);
  const field = getField(fieldId);
  const {
    childFields
  } = field;
  const isHighlighted = fieldToEdit === fieldId;
  const isDimmed = status === 'editingField' && fieldToEdit !== fieldId;
  const isCreateFieldFormVisible = status === 'creatingField' && fieldToAddFieldTo === fieldId;
  const areActionButtonsVisible = status === 'idle';
  const childFieldsArray = (0, _react.useMemo)(() => childFields !== undefined ? childFields.map(getField) : [], [childFields, getField]);
  // Indicate if the field is shadowed by a runtime field with the same name
  // Currently this can only occur for **root level** fields.
  const isShadowed = rootLevelFields.includes(fieldId) && runtimeFieldNames.includes(field.source.name);
  const addField = (0, _react.useCallback)(() => {
    dispatch({
      type: 'documentField.createField',
      value: fieldId
    });
  }, [fieldId, dispatch]);
  const editField = (0, _react.useCallback)(() => {
    dispatch({
      type: 'documentField.editField',
      value: fieldId
    });
  }, [fieldId, dispatch]);
  const toggleExpand = (0, _react.useCallback)(() => {
    // if using static state, set state manually
    if (isAddingFields && setPreviousState !== undefined) {
      const previousField = state.fields.byId[fieldId];
      const nextField = {
        ...previousField,
        isExpanded: !previousField.isExpanded
      };
      setPreviousState({
        ...state,
        fields: {
          ...state.fields,
          byId: {
            ...state.fields.byId,
            [fieldId]: nextField
          }
        }
      });
    } else {
      dispatch({
        type: 'field.toggleExpand',
        value: {
          fieldId
        }
      });
    }
  }, [fieldId, dispatch, isAddingFields, setPreviousState, state]);
  return /*#__PURE__*/_react.default.createElement(_fields_list_item.FieldsListItem, {
    ref: listElement,
    field: field,
    allFields: byId,
    treeDepth: treeDepth,
    isHighlighted: isHighlighted,
    isDimmed: isDimmed,
    isShadowed: isShadowed,
    isCreateFieldFormVisible: isCreateFieldFormVisible,
    areActionButtonsVisible: areActionButtonsVisible,
    isLastItem: isLastItem,
    childFieldsArray: childFieldsArray,
    maxNestedDepth: maxNestedDepth,
    addField: addField,
    editField: editField,
    setPreviousState: setPreviousState,
    toggleExpand: toggleExpand,
    state: state,
    isAddingFields: isAddingFields,
    pendingFieldsRef: pendingFieldsRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  });
};
exports.FieldsListItemContainer = FieldsListItemContainer;