"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IgnoreAboveParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _lib = require("../../../lib");
var _shared_imports = require("../../../shared_imports");
var _edit_field = require("../fields/edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/ignore_above_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IgnoreAboveParameter = ({
  defaultToggleValue
}) => /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.ignoreAboveFieldTitle', {
    defaultMessage: 'Set length limit'
  }),
  description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.ignoreAboveFieldDescription', {
    defaultMessage: 'Strings longer than this value will not be indexed. This is useful for protecting against Lucene’s term character-length limit of 8,191 UTF-8 characters.'
  }),
  docLink: {
    text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.ignoreAboveDocLinkText', {
      defaultMessage: 'Ignore above documentation'
    }),
    href: _documentation.documentationService.getIgnoreAboveLink()
  },
  defaultToggleValue: defaultToggleValue,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 23,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "ignore_above",
  config: (0, _lib.getFieldConfig)('ignore_above'),
  component: _shared_imports.Field,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 5
  }
}));
exports.IgnoreAboveParameter = IgnoreAboveParameter;