"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldDataParameter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _edit_field = require("../fields/edit_field");
var _documentation = require("../../../../../services/documentation");
var _fielddata_frequency_filter_percentage = require("./fielddata_frequency_filter_percentage");
var _fielddata_frequency_filter_absolute = require("./fielddata_frequency_filter_absolute");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/fielddata_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldDataParameter = ({
  field,
  defaultToggleValue
}) => {
  const [valueType, setValueType] = (0, _react.useState)(field.source.fielddata_frequency_filter !== undefined ? field.source.fielddata_frequency_filter.max > 1 ? 'absolute' : 'percentage' : 'percentage');
  function getConfig(fieldProp, type = valueType) {
    return type === 'percentage' ? (0, _lib.getFieldConfig)('fielddata_frequency_filter_percentage', fieldProp) : (0, _lib.getFieldConfig)('fielddata_frequency_filter_absolute', fieldProp);
  }
  const switchType = (min, max) => () => {
    var _nextMinConfig$deseri, _nextMinConfig$deseri2, _nextMaxConfig$deseri, _nextMaxConfig$deseri2;
    const nextValueType = valueType === 'percentage' ? 'absolute' : 'percentage';
    const nextMinConfig = getConfig('min', nextValueType);
    const nextMaxConfig = getConfig('max', nextValueType);
    min.setValue((_nextMinConfig$deseri = (_nextMinConfig$deseri2 = nextMinConfig.deserializer) === null || _nextMinConfig$deseri2 === void 0 ? void 0 : _nextMinConfig$deseri2.call(nextMinConfig, nextMinConfig.defaultValue)) !== null && _nextMinConfig$deseri !== void 0 ? _nextMinConfig$deseri : nextMinConfig.defaultValue);
    max.setValue((_nextMaxConfig$deseri = (_nextMaxConfig$deseri2 = nextMaxConfig.deserializer) === null || _nextMaxConfig$deseri2 === void 0 ? void 0 : _nextMaxConfig$deseri2.call(nextMaxConfig, nextMaxConfig.defaultValue)) !== null && _nextMaxConfig$deseri !== void 0 ? _nextMaxConfig$deseri : nextMaxConfig.defaultValue);
    setValueType(nextValueType);
  };
  return /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.fielddataFormRowTitle', {
      defaultMessage: 'Fielddata'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.fielddataFormRowDescription', {
      defaultMessage: 'Whether to use in-memory fielddata for sorting, aggregations, or scripting.'
    }),
    docLink: {
      text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.fieldDataDocLinkText', {
        defaultMessage: 'Fielddata documentation'
      }),
      href: _documentation.documentationService.getFielddataLink()
    },
    formFieldPath: "fielddata",
    defaultToggleValue: defaultToggleValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      min: {
        path: 'fielddata_frequency_filter.min',
        config: getConfig('min')
      },
      max: {
        path: 'fielddata_frequency_filter.max',
        config: getConfig('max')
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, ({
    min,
    max
  }) => {
    const FielddataFrequencyComponent = valueType === 'percentage' ? _fielddata_frequency_filter_percentage.FielddataFrequencyFilterPercentage : _fielddata_frequency_filter_absolute.FielddataFrequencyFilterAbsolute;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "warning",
      size: "s",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.mappingsEditor.fielddata.fielddataEnabledWarningTitle",
        defaultMessage: "Fielddata can consume significant memory. This is particularly likely when loading high-cardinality text fields. {docsLink}",
        values: {
          docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _documentation.documentationService.getEnablingFielddataLink(),
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 126,
              columnNumber: 25
            }
          }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.fielddataEnabledDocumentationLink', {
            defaultMessage: 'Learn more.'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 19
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.fielddataDocumentFrequencyRangeTitle', {
      defaultMessage: 'Document frequency range'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.fielddata.fielddataFrequencyMessage",
      defaultMessage: "This range determines the terms loaded into memory. Frequency is calculated per segment. Exclude small segments based on their size, in number of documents. {docsLink}",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getFielddataFrequencyLink(),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 164,
            columnNumber: 23
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.fielddataFrequencyDocumentationLink', {
          defaultMessage: 'Learn more.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(FielddataFrequencyComponent, {
      min: min,
      max: max,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "fielddata_frequency_filter.min_segment_size",
      config: (0, _lib.getFieldConfig)('fielddata_frequency_filter', 'min_segment_size'),
      component: _shared_imports.Field,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      compressed: true,
      label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.useAbsoluteValuesFieldLabel', {
        defaultMessage: 'Use absolute values'
      }),
      checked: valueType === 'absolute',
      onChange: switchType(min, max),
      "data-test-subj": "input",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 15
      }
    }));
  }));
};
exports.FieldDataParameter = FieldDataParameter;