"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formSerializer = exports.formDeserializer = exports.ConfigurationForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
var _shared_imports = require("../../shared_imports");
var _constants = require("../../constants");
var _mappings_state_context = require("../../mappings_state_context");
var _dynamic_mapping_section = require("./dynamic_mapping_section");
var _source_field_section = require("./source_field_section");
var _meta_field_section = require("./meta_field_section");
var _routing_section = require("./routing_section");
var _mapper_size_plugin_section = require("./mapper_size_plugin_section");
var _subobjects_section = require("./subobjects_section");
var _configuration_form_schema = require("./configuration_form_schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/configuration_form/configuration_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const serializeSourceField = sourceField => {
  if ((sourceField === null || sourceField === void 0 ? void 0 : sourceField.option) === _source_field_section.SYNTHETIC_SOURCE_OPTION) {
    return {
      mode: _source_field_section.SYNTHETIC_SOURCE_OPTION
    };
  }
  if ((sourceField === null || sourceField === void 0 ? void 0 : sourceField.option) === _source_field_section.DISABLED_SOURCE_OPTION) {
    return {
      enabled: false
    };
  }
  if ((sourceField === null || sourceField === void 0 ? void 0 : sourceField.option) === _source_field_section.STORED_SOURCE_OPTION) {
    return {
      mode: 'stored',
      includes: sourceField.includes,
      excludes: sourceField.excludes
    };
  }
  if (sourceField !== null && sourceField !== void 0 && sourceField.includes || sourceField !== null && sourceField !== void 0 && sourceField.excludes) {
    // If sourceField?.option is undefined, the user hasn't explicitly selected
    // this option, so don't include the `mode` property
    return {
      includes: sourceField.includes,
      excludes: sourceField.excludes
    };
  }
  return undefined;
};
const formSerializer = formData => {
  const {
    dynamicMapping,
    sourceField,
    metaField,
    _routing,
    _size,
    subobjects
  } = formData;
  const dynamic = dynamicMapping !== null && dynamicMapping !== void 0 && dynamicMapping.enabled ? true : dynamicMapping !== null && dynamicMapping !== void 0 && dynamicMapping.throwErrorsForUnmappedFields ? 'strict' : dynamicMapping === null || dynamicMapping === void 0 ? void 0 : dynamicMapping.enabled;
  const serialized = {
    dynamic,
    numeric_detection: dynamicMapping === null || dynamicMapping === void 0 ? void 0 : dynamicMapping.numeric_detection,
    date_detection: dynamicMapping === null || dynamicMapping === void 0 ? void 0 : dynamicMapping.date_detection,
    dynamic_date_formats: dynamicMapping === null || dynamicMapping === void 0 ? void 0 : dynamicMapping.dynamic_date_formats,
    _source: serializeSourceField(sourceField),
    _meta: metaField,
    _routing,
    _size,
    subobjects
  };
  return serialized;
};
exports.formSerializer = formSerializer;
const formDeserializer = formData => {
  const {
    dynamic,
    /* eslint-disable @typescript-eslint/naming-convention */
    numeric_detection,
    date_detection,
    dynamic_date_formats,
    /* eslint-enable @typescript-eslint/naming-convention */
    _source: {
      enabled,
      mode,
      includes,
      excludes
    } = {},
    _meta,
    _routing,
    // For the Mapper Size plugin
    _size,
    subobjects
  } = formData;
  return {
    dynamicMapping: {
      enabled: dynamic === 'strict' ? false : dynamic,
      throwErrorsForUnmappedFields: dynamic === 'strict' ? true : undefined,
      numeric_detection,
      date_detection,
      dynamic_date_formats
    },
    sourceField: {
      option: mode === 'stored' ? _source_field_section.STORED_SOURCE_OPTION : mode === 'synthetic' ? _source_field_section.SYNTHETIC_SOURCE_OPTION : enabled === false ? _source_field_section.DISABLED_SOURCE_OPTION : undefined,
      includes,
      excludes
    },
    metaField: _meta,
    _routing,
    _size,
    subobjects
  };
};
exports.formDeserializer = formDeserializer;
const ConfigurationForm = exports.ConfigurationForm = /*#__PURE__*/_react.default.memo(({
  value,
  esNodesPlugins
}) => {
  const {
    config: {
      enableMappingsSourceFieldSection
    }
  } = (0, _app_context.useAppContext)();
  const isMounted = (0, _react.useRef)(false);
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _configuration_form_schema.configurationFormSchema,
    serializer: formSerializer,
    deserializer: formDeserializer,
    defaultValue: value,
    id: 'configurationForm',
    options: {
      stripUnsetFields: true
    }
  });
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    subscribe,
    submit,
    reset,
    getFormData
  } = form;
  const isMapperSizeSectionVisible = (value === null || value === void 0 ? void 0 : value._size) !== undefined || esNodesPlugins.includes(_constants.MapperSizePluginId);
  (0, _react.useEffect)(() => {
    const subscription = subscribe(({
      data,
      isValid,
      validate
    }) => {
      dispatch({
        type: 'configuration.update',
        value: {
          data,
          isValid,
          validate,
          submitForm: submit
        }
      });
    });
    return subscription.unsubscribe;
  }, [dispatch, subscribe, submit]);
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      // If the value has changed (it probably means that we have loaded a new JSON)
      // we need to reset the form to update the fields values.
      reset({
        resetValues: true,
        defaultValue: value
      });
    }
  }, [value, reset]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;

      // Save a snapshot of the form state so we can get back to it when navigating back to the tab
      const configurationData = getFormData();
      dispatch({
        type: 'configuration.save',
        value: configurationData
      });
    };
  }, [getFormData, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    isInvalid: form.isSubmitted && !form.isValid && !form.isSubmitting,
    error: form.getErrors(),
    "data-test-subj": "advancedConfiguration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_dynamic_mapping_section.DynamicMappingSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_meta_field_section.MetaFieldSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }), enableMappingsSourceFieldSection && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_source_field_section.SourceFieldSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }), " ", /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 34
    }
  })), /*#__PURE__*/_react.default.createElement(_routing_section.RoutingSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }), isMapperSizeSectionVisible && /*#__PURE__*/_react.default.createElement(_mapper_size_plugin_section.MapperSizePluginSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 38
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_subobjects_section.SubobjectsSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }));
});