"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimulateTemplate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _template_serialization = require("../../../../../common/lib/template_serialization");
var _services = require("../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/index_templates/simulate_template/simulate_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  stripEmptyFields
} = _shared_imports.serializers;
const DEFAULT_OVERFLOW_HEIGHT = 550;
const SimulateTemplate = exports.SimulateTemplate = /*#__PURE__*/_react.default.memo(({
  template,
  filters,
  templateName,
  isVirtualized = true,
  overflowHeight = DEFAULT_OVERFLOW_HEIGHT
}) => {
  const [templatePreview, setTemplatePreview] = (0, _react.useState)('{}');
  const updatePreview = (0, _react.useCallback)(async () => {
    var _filteredTemplate;
    if (!templateName && (!template || Object.keys(template).length === 0)) {
      return;
    }
    const indexTemplate = templateName ? undefined : (0, _template_serialization.serializeTemplate)(stripEmptyFields(template, {
      types: ['string']
    }));
    const {
      data,
      error
    } = await (0, _services.simulateIndexTemplate)({
      template: indexTemplate,
      templateName
    });
    let filteredTemplate = data;
    if (data) {
      // "Overlapping" info is only useful when simulating against an index
      // which we don't do here.
      delete data.overlapping;
      if (data.template && data.template.mappings === undefined) {
        // Adding some extra logic to return an empty object for "mappings" as ES does not
        // return one in that case (empty objects _are_ returned for "settings" and "aliases")
        // Issue: https://github.com/elastic/elasticsearch/issues/60968
        data.template.mappings = {};
      }
      if (filters) {
        filteredTemplate = Object.entries(filters).reduce((acc, [key, value]) => {
          if (!value) {
            delete acc[key];
          }
          return acc;
        }, {
          ...data.template
        });
      }
    }
    setTemplatePreview(JSON.stringify((_filteredTemplate = filteredTemplate) !== null && _filteredTemplate !== void 0 ? _filteredTemplate : error, null, 2));
  }, [template, filters, templateName]);
  (0, _react.useEffect)(() => {
    updatePreview();
  }, [updatePreview]);
  const isEmpty = templatePreview === '{}';
  const hasFilters = Boolean(filters);
  if (isEmpty && hasFilters) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.simulateTemplate.noFilterSelected",
        defaultMessage: "Select at least one option to preview.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 13
        }
      }),
      iconType: "pin",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    });
  }
  return isEmpty ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    "data-test-subj": "simulateTemplatePreview",
    isVirtualized: isVirtualized,
    overflowHeight: overflowHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, templatePreview);
});