"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplatesSelection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _component_templates_list_item = require("./component_templates_list_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_selector/component_templates_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ComponentTemplatesSelection = ({
  components,
  onReorder,
  listItemProps
}) => {
  const onDragEnd = ({
    source,
    destination
  }) => {
    if (source && destination) {
      const items = (0, _eui.euiDragDropReorder)(components, source.index, destination.index);
      onReorder(items);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "componentTemplates",
    spacing: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, components.map((component, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "none",
    key: component.name,
    index: idx,
    draggableId: component.name,
    customDragHandle: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }, provided => /*#__PURE__*/_react.default.createElement(_component_templates_list_item.ComponentTemplatesListItem, (0, _extends2.default)({
    component: component,
    dragHandleProps: provided.dragHandleProps
  }, listItemProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 15
    }
  }))))));
};
exports.ComponentTemplatesSelection = ComponentTemplatesSelection;