"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexLifecycleTab = exports.IndexLifecycleSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _navigation = require("../../application/services/navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/extend_index_management/components/index_lifecycle_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndexLifecycleSummary = ({
  index,
  getUrlForApp,
  euiTheme
}) => {
  var _phaseToBadgeMapping;
  const {
    ilm: ilmData
  } = index;
  // only ILM managed indices render the ILM tab
  const ilm = ilmData;
  const isBorealis = euiTheme.themeName === 'EUI_THEME_BOREALIS';

  // Changing the mappings for the phases in Borealis as a mid-term solution. See https://github.com/elastic/kibana/issues/203664#issuecomment-2536593361.
  const phaseToBadgeMapping = {
    hot: {
      color: isBorealis ? euiTheme.colors.vis.euiColorVis6 : euiTheme.colors.vis.euiColorVis9,
      label: 'Hot'
    },
    warm: {
      color: isBorealis ? euiTheme.colors.vis.euiColorVis9 : euiTheme.colors.vis.euiColorVis5,
      label: 'Warm'
    },
    cold: {
      color: isBorealis ? euiTheme.colors.vis.euiColorVis2 : euiTheme.colors.vis.euiColorVis1,
      label: 'Cold'
    },
    frozen: {
      color: euiTheme.colors.vis.euiColorVis4,
      label: 'Frozen'
    },
    delete: {
      color: 'default',
      label: 'Delete'
    }
  };

  // if ilm.phase is an unexpected value, then display a default badge
  const phaseBadgeConfig = (_phaseToBadgeMapping = phaseToBadgeMapping[ilm.phase]) !== null && _phaseToBadgeMapping !== void 0 ? _phaseToBadgeMapping : {
    color: 'default',
    label: ilm.phase
  };
  const lifecycleProperties = [{
    title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.policyNameTitle', {
      defaultMessage: 'Policy name'
    }),
    description: ilm.policy
  }, {
    title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentPhaseTitle', {
      defaultMessage: 'Current phase'
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: phaseBadgeConfig.color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 20
      }
    }, phaseBadgeConfig.label)
  }];
  if (ilm.action) {
    lifecycleProperties.push({
      title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentActionTitle', {
        defaultMessage: 'Current action'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 20
        }
      }, ilm.action)
    });
  }
  if (ilm.action_time_millis) {
    lifecycleProperties.push({
      title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentActionTimeTitle', {
        defaultMessage: 'Current action time'
      }),
      description: (0, _momentTimezone.default)(ilm.action_time_millis).format('YYYY-MM-DD HH:mm:ss')
    });
  }
  if (ilm.step) {
    lifecycleProperties.push({
      title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentStepTitle', {
        defaultMessage: 'Current step'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 20
        }
      }, ilm.step)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: (0, _react2.css)`
            min-width: 400px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    "data-test-subj": "policyPropertiesPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Lifecycle policy",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.policyCardTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "primary",
    href: getUrlForApp('management', {
      path: `data/index_lifecycle_management/${(0, _navigation.getPolicyEditPath)(ilm.policy)}`
    }),
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Edit policy in ILM",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.ilmLinkLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    rowGutterSize: "m",
    type: "responsiveColumn",
    columnWidths: [1, 1],
    listItems: lifecycleProperties,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    css: (0, _react2.css)`
            min-width: 600px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, ilm.step_info && ilm.step === 'ERROR' &&
  /*#__PURE__*/
  // there is an error
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "danger",
    hasBorder: true,
    grow: false,
    "data-test-subj": "policyErrorPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Lifecycle error",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.lifecycleErrorTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 19
    }
  }, JSON.stringify({
    failed_step: ilm.failed_step,
    step_info: ilm.step_info
  }, null, 2)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 15
    }
  })), ilm.step_info && ilm.step !== 'ERROR' &&
  /*#__PURE__*/
  // ILM is waiting for the step to complete
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    "data-test-subj": "policyStepPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Current step info",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.stepInfoTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 19
    }
  }, JSON.stringify(ilm.step_info, null, 2)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  })), ilm.phase_execution && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    "data-test-subj": "phaseDefinitionPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Current phase definition",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.phaseDefinitionTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 15
    }
  }, JSON.stringify(ilm.phase_execution, null, 2))))));
};
exports.IndexLifecycleSummary = IndexLifecycleSummary;
const indexLifecycleTab = exports.indexLifecycleTab = {
  id: 'ilm',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Index lifecycle",
    id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.tabHeaderLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 5
    }
  }),
  order: 50,
  renderTabContent: IndexLifecycleSummary,
  shouldRenderTab: ({
    index
  }) => {
    return !!index.ilm && index.ilm.managed;
  }
};