"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../../../../../shared_imports");
var _lib = require("../../lib");
var _form = require("../../form");
var _timeline = require("./timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/timeline/timeline.container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Timeline = () => {
  var _timings$warm, _timings$cold, _timings$frozen, _timings$delete, _formData$_meta, _formData$_meta$delet;
  const [formData] = (0, _shared_imports.useFormData)();
  const timings = (0, _lib.formDataToAbsoluteTimings)(formData);
  const {
    isUsingRollover
  } = (0, _form.useConfiguration)();
  return /*#__PURE__*/_react.default.createElement(_timeline.Timeline, {
    hotPhaseMinAge: timings.hot.min_age,
    warmPhaseMinAge: (_timings$warm = timings.warm) === null || _timings$warm === void 0 ? void 0 : _timings$warm.min_age,
    coldPhaseMinAge: (_timings$cold = timings.cold) === null || _timings$cold === void 0 ? void 0 : _timings$cold.min_age,
    frozenPhaseMinAge: (_timings$frozen = timings.frozen) === null || _timings$frozen === void 0 ? void 0 : _timings$frozen.min_age,
    deletePhaseMinAge: (_timings$delete = timings.delete) === null || _timings$delete === void 0 ? void 0 : _timings$delete.min_age,
    isUsingRollover: isUsingRollover,
    hasDeletePhase: Boolean((_formData$_meta = formData._meta) === null || _formData$_meta === void 0 ? void 0 : (_formData$_meta$delet = _formData$_meta.delete) === null || _formData$_meta$delet === void 0 ? void 0 : _formData$_meta$delet.enabled),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
};
exports.Timeline = Timeline;