"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Phase = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../../../shared_imports");
var _i18n_texts = require("../../../i18n_texts");
var _phase_icon = require("../../phase_icon");
var _phase_footer = require("../../phase_footer");
var _phase_title = require("./phase_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/phase/phase.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    settingsAccordionButtonClassName: (0, _css.css)`
      color: ${euiTheme.colors.primary};
      padding-top: ${euiTheme.size.s};
      padding-bottom: ${euiTheme.size.s};
    `,
    halfWidth: (0, _react2.css)`
      max-width: 50%;
    `
  };
};
const Phase = ({
  children,
  topLevelSettings,
  phase
}) => {
  const styles = useStyles();
  const enabledPath = `_meta.${phase}.enabled`;
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [enabledPath]
  });
  const isHotPhase = phase === 'hot';
  const isDeletePhase = phase === 'delete';
  // hot phase is always enabled
  const enabled = (0, _lodash.get)(formData, enabledPath) || isHotPhase;

  // delete phase is hidden when disabled
  if (isDeletePhase && !enabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTimelineItem, {
    icon: /*#__PURE__*/_react.default.createElement(_phase_icon.PhaseIcon, {
      enabled: enabled,
      phase: phase,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }),
    verticalAlign: "top",
    "data-test-subj": `${phase}-phase`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    color: "transparent",
    hasBorder: true,
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: enabled ? 'transparent' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_phase_title.PhaseTitle, {
    phase: phase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    css: styles.halfWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, _i18n_texts.i18nTexts.editPolicy.descriptions[phase]), enabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!topLevelSettings ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 19
    }
  }), topLevelSettings) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 17
    }
  }), children ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `${phase}-settingsSwitch`,
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.phaseSettings.buttonLabel",
      defaultMessage: "Advanced settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 21
      }
    }),
    buttonClassName: styles.settingsAccordionButtonClassName,
    extraAction: !isDeletePhase && /*#__PURE__*/_react.default.createElement(_phase_footer.PhaseFooter, {
      phase: phase,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 50
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 19
    }
  }), children) : !isDeletePhase && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_phase_footer.PhaseFooter, {
    phase: phase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 23
    }
  })))))));
};
exports.Phase = Phase;