"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIntegrationsTestRendererMock = exports.createFleetTestRendererMock = void 0;
var _history = require("history");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@testing-library/react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/core/public");
var _experimental_features = require("../../common/experimental_features");
var _app = require("../applications/fleet/app");
var _app2 = require("../applications/integrations/app");
var _services = require("../services");
var _plugin_configuration = require("./plugin_configuration");
var _plugin_interfaces = require("./plugin_interfaces");
var _fleet_start_services = require("./fleet_start_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/mock/create_test_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Test Renderer that includes mocked services and interfaces used during Fleet applicaiton rendering.
 * Any of the properties in this interface can be manipulated prior to `render()` if wanting to customize
 * the rendering context.
 */

// disable retries to avoid test flakiness
const queryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      retry: false
    },
    mutations: {
      retry: false
    }
  }
});
const createFleetTestRendererMock = () => {
  const basePath = '/mock';
  const extensions = {};
  const startServices = (0, _fleet_start_services.createStartServices)(basePath);
  const history = (0, _history.createMemoryHistory)({
    initialEntries: [basePath]
  });
  const mountHistory = new _public2.CoreScopedHistory(history, basePath);
  _services.ExperimentalFeaturesService.init(_experimental_features.allowedExperimentalValues);
  const HookWrapper = /*#__PURE__*/(0, _react.memo)(({
    children
  }) => {
    return /*#__PURE__*/_react.default.createElement(startServices.i18n.Context, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: mountHistory,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
      client: queryClient,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...startServices
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    }, children))));
  });
  const testRendererMocks = {
    history,
    mountHistory,
    startServices,
    config: (0, _plugin_configuration.createConfigurationMock)(),
    startInterface: (0, _plugin_interfaces.createStartMock)(extensions),
    kibanaVersion: '8.0.0',
    setHeaderActionMenu: jest.fn(),
    AppWrapper: /*#__PURE__*/(0, _react.memo)(({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(_app.FleetAppContext, {
        startServices: testRendererMocks.startServices,
        config: testRendererMocks.config,
        history: testRendererMocks.mountHistory,
        kibanaVersion: testRendererMocks.kibanaVersion,
        extensions: extensions,
        routerHistory: testRendererMocks.history,
        fleetStatus: {
          enabled: true,
          isLoading: false,
          isReady: true
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 9
        }
      }, children);
    }),
    HookWrapper,
    renderHook: (callback, ExtraWrapper = /*#__PURE__*/(0, _react.memo)(({
      children
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children))) => {
      const wrapper = ({
        children
      }) => /*#__PURE__*/_react.default.createElement(testRendererMocks.HookWrapper, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(ExtraWrapper, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 11
        }
      }, children));
      return (0, _react2.renderHook)(callback, {
        wrapper
      });
    },
    waitFor: _react2.waitFor,
    render: (ui, options) => {
      let renderResponse;
      (0, _react2.act)(() => {
        renderResponse = (0, _react2.render)(ui, {
          wrapper: testRendererMocks.AppWrapper,
          ...options
        });
      });
      return renderResponse;
    }
  };
  return testRendererMocks;
};
exports.createFleetTestRendererMock = createFleetTestRendererMock;
const createIntegrationsTestRendererMock = () => {
  const basePath = '/mock';
  const extensions = {};
  _services.ExperimentalFeaturesService.init(_experimental_features.allowedExperimentalValues);
  const startServices = (0, _fleet_start_services.createStartServices)(basePath);
  const HookWrapper = /*#__PURE__*/(0, _react.memo)(({
    children
  }) => {
    return /*#__PURE__*/_react.default.createElement(startServices.i18n.Context, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...startServices
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }, children));
  });
  const testRendererMocks = {
    history: (0, _history.createMemoryHistory)(),
    mountHistory: new _public2.CoreScopedHistory((0, _history.createMemoryHistory)({
      initialEntries: [basePath]
    }), basePath),
    startServices,
    config: (0, _plugin_configuration.createConfigurationMock)(),
    startInterface: (0, _plugin_interfaces.createStartMock)(extensions),
    kibanaVersion: '8.0.0',
    setHeaderActionMenu: jest.fn(),
    AppWrapper: /*#__PURE__*/(0, _react.memo)(({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(_app2.IntegrationsAppContext, {
        basepath: basePath,
        startServices: testRendererMocks.startServices,
        config: testRendererMocks.config,
        history: testRendererMocks.mountHistory,
        kibanaVersion: testRendererMocks.kibanaVersion,
        extensions: extensions,
        routerHistory: testRendererMocks.history,
        setHeaderActionMenu: () => {},
        fleetStatus: {
          enabled: true,
          isLoading: false,
          isReady: true
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 9
        }
      }, children);
    }),
    HookWrapper,
    render: (ui, options) => {
      let renderResponse;
      (0, _react2.act)(() => {
        renderResponse = (0, _react2.render)(ui, {
          wrapper: testRendererMocks.AppWrapper,
          ...options
        });
      });
      return renderResponse;
    },
    renderHook: (callback, ExtraWrapper = /*#__PURE__*/(0, _react.memo)(({
      children
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children))) => {
      const wrapper = ({
        children
      }) => /*#__PURE__*/_react.default.createElement(testRendererMocks.HookWrapper, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(ExtraWrapper, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 11
        }
      }, children));
      return (0, _react2.renderHook)(callback, {
        wrapper
      });
    },
    waitFor: _react2.waitFor
  };
  return testRendererMocks;
};
exports.createIntegrationsTestRendererMock = createIntegrationsTestRendererMock;