"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicySelection = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _agent_policy_package_badges = require("../agent_policy_package_badges");
var _hooks = require("../../hooks");
var _advanced_agent_authentication_settings = require("./advanced_agent_authentication_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/agent_policy_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentPolicyFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  .euiFormRow__label {
    width: 100%;
  }
`;
const AgentPolicySelection = props => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    agentPolicies,
    selectedPolicyId,
    setSelectedPolicyId,
    excludeFleetServer,
    onClickCreatePolicy,
    isFleetServerPolicy
  } = props;
  const authz = (0, _hooks.useAuthz)();
  const onChangeCallback = event => {
    const {
      value
    } = event.target;
    setSelectedPolicyId(value);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, isFleetServerPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentStepAgentPolicy.selectAgentPolicyFleetServerText",
    defaultMessage: "Fleet Server runs on Elastic Agent, and agents are enrolled in agent policies which represent hosts. You can select an existing agent policy configured for Fleet Server, or you may choose to create a new one.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentStepAgentPolicy.createAgentPolicyText",
    defaultMessage: "Settings for the monitored host are configured in the {agentPolicy}. Choose an agent policy or create a new one.",
    values: {
      agentPolicy: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.agentPolicy,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.createAgentPolicyDocLink",
        defaultMessage: "agent policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AgentPolicyFormRow, {
    fullWidth: true,
    label: authz.fleet.allAgentPolicies && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onClickCreatePolicy,
      "data-test-subj": "createNewAgentPolicyLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.enrollmentStepAgentPolicy.addPolicyButton",
      defaultMessage: "Create new agent policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 19
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    isLoading: !agentPolicies,
    options: agentPolicies.filter(policy => !(policy !== null && policy !== void 0 && policy.supports_agentless)).map(agentPolicy => ({
      value: agentPolicy.id,
      text: agentPolicy.name
    })),
    value: selectedPolicyId,
    onChange: onChangeCallback,
    "aria-label": _i18n.i18n.translate('xpack.fleet.enrollmentStepAgentPolicy.policySelectAriaLabel', {
      defaultMessage: 'Agent policy'
    }),
    hasNoInitialSelection: !selectedPolicyId,
    "data-test-subj": "agentPolicyDropdown",
    isInvalid: !selectedPolicyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  })), authz.fleet.readAgentPolicies && selectedPolicyId && !isFleetServerPolicy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_package_badges.AgentPolicyPackageBadges, {
    agentPolicyId: selectedPolicyId,
    excludeFleetServer: excludeFleetServer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  })), props.withKeySelection && props.onKeyChange && selectedPolicyId && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_advanced_agent_authentication_settings.AdvancedAgentAuthenticationSettings, {
    selectedApiKeyId: props.selectedApiKeyId,
    onKeyChange: props.onKeyChange,
    initialAuthenticationSettingsOpen: !props.selectedApiKeyId,
    agentPolicyId: selectedPolicyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  })));
};
exports.AgentPolicySelection = AgentPolicySelection;