"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeploymentDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _deployment_details = require("@kbn/cloud/deployment_details");
var _hooks = require("../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/components/header/deployment_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DeploymentDetails = () => {
  const [isOpen, setIsOpen] = _react.default.useState(false);
  const {
    share,
    cloud,
    docLinks,
    application
  } = (0, _hooks.useStartServices)();

  // If the cloud plugin isn't enabled, we can't display the flyout.
  if (!cloud) {
    return null;
  }
  const {
    isCloudEnabled,
    cloudId
  } = cloud;

  // If cloud isn't enabled or we don't have a cloudId we don't render the button.
  if (!isCloudEnabled || !cloudId) {
    return null;
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    onClick: () => setIsOpen(!isOpen),
    isActive: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.fleet.integrations.connectionDetailsButton', {
    defaultMessage: 'Connection details'
  }));
  return /*#__PURE__*/_react.default.createElement(_deployment_details.DeploymentDetailsKibanaProvider, {
    core: {
      application
    },
    share: share,
    cloud: cloud,
    docLinks: docLinks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    button: button,
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 450
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_deployment_details.DeploymentDetails, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }))));
};
exports.DeploymentDetails = DeploymentDetails;