"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogstashApiKey = useLogstashApiKey;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/logstash_instructions/hooks.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useLogstashApiKey() {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [apiKey, setApiKey] = (0, _react.useState)();
  const startServices = (0, _hooks.useStartServices)();
  const {
    notifications
  } = startServices;
  const generateApiKey = (0, _react.useCallback)(async () => {
    try {
      var _res$data;
      setIsLoading(true);
      const res = await (0, _hooks.sendPostLogstashApiKeys)();
      if (res.error) {
        throw res.error;
      }
      setApiKey((_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.api_key);
    } catch (err) {
      if (err.statusCode === 403) {
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.fleet.settings.logstashInstructions.generateApiKeyError', {
            defaultMessage: 'Cannot generate an API key'
          }),
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.logstashInstructions.generateApiKeyPermissions",
            defaultMessage: "You need the cluster permissions: {clusterPermissions}{br} and the index permissions: {indexPermissions}{br}for indexes: {br}{indexes}",
            values: {
              clusterPermissions: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 49,
                  columnNumber: 21
                }
              }, _constants.LOGSTASH_API_KEY_CLUSTER_PERMISSIONS.join(', ')),
              indexPermissions: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 52,
                  columnNumber: 21
                }
              }, _constants.LOGSTASH_API_KEY_INDICES_PRIVILEGES.join(', ')),
              indexes: _constants.LOGSTASH_API_KEY_INDICES.map(index => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
                key: index,
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 55,
                  columnNumber: 21
                }
              }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 56,
                  columnNumber: 23
                }
              }, index), /*#__PURE__*/_react.default.createElement("br", {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 57,
                  columnNumber: 23
                }
              }))),
              br: /*#__PURE__*/_react.default.createElement("br", {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 60,
                  columnNumber: 23
                }
              })
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 44,
              columnNumber: 15
            }
          }), startServices)
        }, {});
      } else {
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.fleet.settings.logstashInstructions.generateApiKeyError', {
            defaultMessage: 'Cannot generate an API key'
          })
        });
      }
    } finally {
      setIsLoading(false);
    }
  }, [notifications.toasts, startServices]);
  return (0, _react.useMemo)(() => ({
    isLoading,
    generateApiKey,
    apiKey
  }), [isLoading, generateApiKey, apiKey]);
}