"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/filter_bar/tags_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TagsFilter = ({
  tags,
  selectedTags,
  onSelectedTagsChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isTagsFilterOpen, setIsTagsFilterOpen] = (0, _react.useState)(false);
  const addTagsFilter = tag => {
    onSelectedTagsChange([...selectedTags, tag]);
  };
  const removeTagsFilter = tag => {
    onSelectedTagsChange(selectedTags.filter(t => t !== tag));
  };
  const getOptions = (0, _react.useCallback)(() => {
    return tags.map(tag => ({
      label: tag,
      checked: selectedTags.includes(tag) ? 'on' : undefined,
      key: tag,
      'data-test-subj': 'agentList.tagFilterOption'
    }));
  }, [tags, selectedTags]);
  const [options, setOptions] = (0, _react.useState)(getOptions());
  (0, _react.useEffect)(() => {
    setOptions(getOptions());
  }, [getOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    zIndex: Number(euiTheme.levels.header) - 1,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      onClick: () => setIsTagsFilterOpen(!isTagsFilterOpen),
      isSelected: isTagsFilterOpen,
      hasActiveFilters: selectedTags.length > 0,
      numActiveFilters: selectedTags.length,
      numFilters: tags.length,
      disabled: tags.length === 0,
      "data-test-subj": "agentList.tagsFilter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.tagsFilterText",
      defaultMessage: "Tags",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    })),
    isOpen: isTagsFilterOpen,
    closePopover: () => setIsTagsFilterOpen(false),
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    searchable: true,
    onChange: newOptions => {
      newOptions.forEach((option, index) => {
        if (option.checked !== options[index].checked) {
          const tag = option.key;
          if (option.checked !== 'on') {
            removeTagsFilter(tag);
            return;
          } else {
            addTagsFilter(tag);
            return;
          }
        }
      });
      setOptions(newOptions);
    },
    "data-test-subj": "agentList.agentPolicyFilterOptions",
    listProps: {
      paddingSize: 's',
      style: {
        minWidth: 140
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "error",
    color: "danger",
    "data-test-subj": "agentList.tagFilterClearAllBtn",
    onClick: () => {
      onSelectedTagsChange([]);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.tagsFilterClearAllBtnText",
    defaultMessage: "Clear all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  })))));
};
exports.TagsFilter = TagsFilter;