"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreatePackagePolicySinglePageLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _setup_technology = require("../hooks/setup_technology");
var _layouts = require("../../../../../layouts");
var _components = require("../../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/single_page_layout/components/layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyName = (0, _styledComponents.default)(_eui.EuiDescriptionListDescription)`
  margin-left: auto;
  max-width: 250px;
  text-overflow: ellipsis;
  white-space: nowrap;
  overflow: hidden;
`;
const CreatePackagePolicySinglePageLayout = exports.CreatePackagePolicySinglePageLayout = /*#__PURE__*/(0, _react.memo)(({
  from,
  cancelUrl,
  onCancel,
  agentPolicy,
  packageInfo,
  integrationInfo,
  children,
  'data-test-subj': dataTestSubj,
  tabs = []
}) => {
  const isAdd = (0, _react.useMemo)(() => ['package', 'policy'].includes(from), [from]);
  const isEdit = (0, _react.useMemo)(() => ['edit', 'package-edit'].includes(from), [from]);
  const isUpgrade = (0, _react.useMemo)(() => ['upgrade-from-fleet-policy-list', 'upgrade-from-integrations-policy-list', 'upgrade-from-extension'].includes(from), [from]);
  const pageTitle = (0, _react.useMemo)(() => {
    if ((isAdd || isEdit || isUpgrade) && packageInfo) {
      let pageTitleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.pageTitleWithPackageName",
        defaultMessage: "Add {packageName} integration",
        values: {
          packageName: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || packageInfo.title
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 11
        }
      });
      if (isEdit) {
        pageTitleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.editPackagePolicy.editPageTitleWithPackageName",
          defaultMessage: "Edit {packageName} integration",
          values: {
            packageName: packageInfo.title
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 13
          }
        });
      } else if (isUpgrade) {
        pageTitleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.editPackagePolicy.upgradePageTitleWithPackageName",
          defaultMessage: "Upgrade {packageName} integration",
          values: {
            packageName: packageInfo.title
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 13
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
        packageName: (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) || '',
        integrationName: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name,
        version: (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.version) || '',
        icons: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.icons) || (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.icons),
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": `${dataTestSubj}_pageTitle`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 17
        }
      }, pageTitleText))));
    }
    if (isEdit) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": `${dataTestSubj}_pageTitle`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.editPackagePolicy.pageTitle",
        defaultMessage: "Edit integration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 15
        }
      })));
    }
    if (isUpgrade) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        "data-test-subj": `${dataTestSubj}_pageTitle`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.upgradePackagePolicy.pageTitle",
        defaultMessage: "Upgrade integration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 15
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.pageTitle",
      defaultMessage: "Add integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    })));
  }, [dataTestSubj, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.icons, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title, packageInfo, isAdd, isEdit, isUpgrade]);
  const pageDescription = (0, _react.useMemo)(() => {
    if (isEdit) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.editPackagePolicy.pageDescription",
        defaultMessage: "Modify integration settings and deploy changes to the selected agent policies.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 11
        }
      });
    } else if (isAdd) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.pageDescriptionfromPolicy",
        defaultMessage: "Configure an integration for the selected agent policies.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 11
        }
      });
    } else if (isUpgrade) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.upgradePackagePolicy.pageDescriptionFromUpgrade",
        defaultMessage: "Upgrade this integration and deploy changes to the selected agent policies.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 11
        }
      });
    } else {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.pageDescriptionfromPackage",
        defaultMessage: "Follow these instructions to add this integration to agent policies.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 11
        }
      });
    }
  }, [isAdd, isEdit, isUpgrade]);
  const leftColumn = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "arrowLeft",
    flush: "left",
    href: cancelUrl,
    onClick: onCancel,
    "data-test-subj": `${dataTestSubj}_cancelBackLink`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.cancelLinkText",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 9
    }
  }, pageTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }, pageDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  })));
  const {
    isAgentlessAgentPolicy
  } = (0, _setup_technology.useAgentless)();
  const hasAgentBasedPolicyId = !isAgentlessAgentPolicy(agentPolicy);
  const showAgentPolicyName = agentPolicy && (isAdd || isEdit) && hasAgentBasedPolicyId;
  const rightColumn = showAgentPolicyName ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    className: "eui-textRight",
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.agentPolicyNameLabel",
    defaultMessage: "Agent policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(AgentPolicyName, {
    className: "eui-textBreakWord",
    title: (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.name) || '-',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  }, (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.name) || '-')) : undefined;
  const maxWidth = 800;
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    restrictHeaderWidth: maxWidth,
    restrictWidth: maxWidth,
    leftColumn: leftColumn,
    rightColumn: rightColumn,
    rightColumnGrow: false,
    "data-test-subj": dataTestSubj,
    tabs: tabs.map(({
      title,
      ...rest
    }) => ({
      name: title,
      ...rest
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 7
    }
  }, children);
});