"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/components/dataset_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  .euiFormRow__label {
    flex: 1;
  }

  .euiFormRow__fieldWrapper > .euiPanel {
    padding: ${props => {
  var _props$theme$eui;
  return (_props$theme$eui = props.theme.eui) === null || _props$theme$eui === void 0 ? void 0 : _props$theme$eui.euiSizeXS;
}};
  }
`;
const DatasetComponent = ({
  value,
  errors,
  onChange,
  datastreams,
  isDisabled,
  isInvalid,
  pkgName = '',
  fieldLabel,
  description
}) => {
  var _datastreams$map;
  const datasetOptions = (_datastreams$map = datastreams.map(datastream => ({
    label: datastream.dataset,
    value: datastream
  }))) !== null && _datastreams$map !== void 0 ? _datastreams$map : [];
  const existingGenericStream = datasetOptions.find(ds => ds.label === _constants.GENERIC_DATASET_NAME);
  const valueAsOption = value ? typeof value === 'string' ? {
    label: value,
    value: {
      dataset: value,
      package: pkgName
    }
  } : {
    label: value.dataset,
    value: {
      dataset: value.dataset,
      package: value.package
    }
  } : undefined;
  const defaultOption = valueAsOption || existingGenericStream || {
    label: _constants.GENERIC_DATASET_NAME,
    value: {
      dataset: _constants.GENERIC_DATASET_NAME,
      package: pkgName
    }
  };
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([defaultOption]);
  const error = errors ? errors.join(', ') : undefined;
  (0, _react.useEffect)(() => {
    if (!value || typeof value === 'string') onChange(defaultOption.value);
  }, [value, defaultOption.value, onChange, pkgName]);
  const onDatasetChange = newSelectedOptions => {
    setSelectedOptions(newSelectedOptions);
    const dataStream = newSelectedOptions[0].value;
    onChange({
      dataset: newSelectedOptions[0].label,
      package: !dataStream || typeof dataStream === 'string' ? pkgName : dataStream.package
    });
  };
  const onCreateOption = (searchValue = '') => {
    const normalizedSearchValue = searchValue.trim().toLowerCase();
    if (!normalizedSearchValue) {
      return;
    }
    const newOption = {
      label: searchValue,
      value: {
        dataset: searchValue,
        package: pkgName
      }
    };
    setSelectedOptions([newOption]);
    onChange({
      dataset: searchValue,
      package: pkgName
    });
  };
  return /*#__PURE__*/_react.default.createElement(FormRow, {
    isInvalid: isInvalid,
    error: error,
    hasChildLabel: true,
    label: fieldLabel,
    helpText: description && /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, {
      children: description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 32
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.datasetCombo.ariaLabel', {
      defaultMessage: 'Dataset combo box'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.datasetCombo.placeholder', {
      defaultMessage: 'Select a dataset'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: datasetOptions,
    selectedOptions: selectedOptions,
    onCreateOption: onCreateOption,
    onChange: onDatasetChange,
    customOptionText: _i18n.i18n.translate('xpack.fleet.datasetCombo.customOptionText', {
      defaultMessage: 'Add {searchValue} as a custom option',
      values: {
        searchValue: '{searchValue}'
      }
    }),
    isClearable: false,
    isDisabled: isDisabled,
    "data-test-subj": "datasetComboBox",
    isInvalid: isInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }), valueAsOption && valueAsOption.value.package !== pkgName && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.datasetCombo.warning",
    defaultMessage: "This data stream is managed by the {package} integration, {learnMore}.",
    values: {
      package: valueAsOption.value.package,
      learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.datasetCombo.warningTooltip",
          defaultMessage: "The destination data stream may not be designed to receive data from this integration, check that the mappings and ingest pipelines are compatible before sending data.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 159,
            columnNumber: 25
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.fleet.datasetCombo.learnMoreLink', {
        defaultMessage: 'learn more'
      })))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  })))));
};
exports.DatasetComponent = DatasetComponent;