"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexNameForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _validate_index_name = require("../../validate_index_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/file_upload/public/components/geo_upload_form/index_name_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class IndexNameForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onIndexNameChange", event => {
      const indexName = event.target.value;
      this.props.onIndexNameChange(indexName);
      this._validateIndexName(indexName);
      this.props.onIndexNameValidationStart();
    });
    (0, _defineProperty2.default)(this, "_validateIndexName", _lodash.default.debounce(async indexName => {
      const indexNameError = await (0, _validate_index_name.validateIndexName)(indexName);
      if (!this._isMounted || indexName !== this.props.indexName) {
        return;
      }
      this.props.onIndexNameValidationEnd();
      this.props.onIndexNameChange(indexName, indexNameError);
    }, 500));
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    const errors = [...(this.props.indexNameError ? [this.props.indexNameError] : [])];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.fileUpload.indexNameForm.enterIndexNameLabel', {
        defaultMessage: 'Index name'
      }),
      isInvalid: !!errors.length,
      error: errors,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "fileUploadIndexNameInput",
      value: this.props.indexName,
      onChange: this._onIndexNameChange,
      isInvalid: !!errors.length,
      "aria-label": _i18n.i18n.translate('xpack.fileUpload.indexNameForm.indexNameReqField', {
        defaultMessage: 'Index name, required field'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.fileUpload.indexNameForm.indexNameGuidelines', {
        defaultMessage: 'Index name guidelines'
      }),
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("ul", {
      style: {
        marginBottom: 0
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.mustBeNewIndex', {
      defaultMessage: 'Must be a new index'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.lowercaseOnly', {
      defaultMessage: 'Lowercase only'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.cannotInclude', {
      defaultMessage: 'Cannot include \\\\, /, *, ?, ", <, >, |, \
                  " " (space character), , (comma), #'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.cannotStartWith', {
      defaultMessage: 'Cannot start with -, _, +'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.cannotBe', {
      defaultMessage: 'Cannot be . or ..'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.length', {
      defaultMessage: 'Cannot be longer than 255 bytes (note it is bytes, \
                  so multi-byte characters will count towards the 255 \
                  limit faster)'
    })))));
  }
}
exports.IndexNameForm = IndexNameForm;