"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gaugeRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _reactDom = require("react-dom");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _analytics = require("@kbn/analytics");
var _ebtTools = require("@kbn/ebt-tools");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _common = require("../../common");
var _services = require("../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_gauge/public/expression_renderers/gauge_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const gaugeRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_GAUGE_NAME,
  displayName: _i18n.i18n.translate('expressionGauge.renderer.visualizationName', {
    defaultMessage: 'Gauge'
  }),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const performanceTracker = (0, _ebtTools.createPerformanceTracker)({
      type: _ebtTools.PERFORMANCE_TRACKER_TYPES.PANEL,
      subType: _common.EXPRESSION_GAUGE_NAME
    });
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.PRE_RENDER);
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const renderComplete = () => {
      performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_COMPLETE);
      let type;
      switch (config.args.shape) {
        case _common.GaugeShapes.HORIZONTAL_BULLET:
          type = `${_common.EXPRESSION_GAUGE_NAME}_horizontal`;
          break;
        case _common.GaugeShapes.VERTICAL_BULLET:
          type = `${_common.EXPRESSION_GAUGE_NAME}_vertical`;
          break;
        case _common.GaugeShapes.SEMI_CIRCLE:
          type = `${_common.EXPRESSION_GAUGE_NAME}_semi_circle`;
          break;
        case _common.GaugeShapes.ARC:
          type = `${_common.EXPRESSION_GAUGE_NAME}_arc`;
          break;
        case _common.GaugeShapes.CIRCLE:
          type = `${_common.EXPRESSION_GAUGE_NAME}_circle`;
          break;
        default:
          type = _common.EXPRESSION_GAUGE_NAME;
      }
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        const events = [`render_${visualizationType}_${type}`, config.canNavigateToLens ? `render_${visualizationType}_${type}_convertable` : undefined].filter(event => Boolean(event));
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, events);
      }
      handlers.done();
    };
    const setChartSize = chartSizeSpec => {
      const event = {
        name: 'chartSize',
        data: chartSizeSpec
      };
      handlers.event(event);
    };
    const {
      GaugeComponent
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/gauge_component')));
    performanceTracker.mark(_ebtTools.PERFORMANCE_TRACKER_MARKS.RENDER_START);
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-scrollBar",
      "data-test-subj": "gaugeChart",
      css: (0, _react2.css)`
            height: 100%;
            width: 100%;
            // the FocusTrap is adding extra divs which are making the visualization redraw twice
            // with a visible glitch. This make the chart library resilient to this extra reflow
            overflow: hidden;
            user-select: text;
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(GaugeComponent, (0, _extends2.default)({}, config, {
      setChartSize: setChartSize,
      formatFactory: (0, _services.getFormatService)().deserialize,
      chartsThemeService: plugins.charts.theme,
      paletteService: (0, _services.getPaletteService)(),
      renderComplete: renderComplete,
      uiState: handlers.uiState,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    })))), domNode);
  }
});
exports.gaugeRenderer = gaugeRenderer;