"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewApiRequestFlyout = exports.ApiRequestFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lzString = require("lz-string");
var _eui = require("@elastic/eui");
var _public = require("@kbn/core/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/public/components/view_api_request_flyout/view_api_request_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ApiRequestFlyout = ({
  title,
  description,
  request,
  closeFlyout,
  flyoutProps,
  urlService,
  application
}) => {
  var _application$capabili, _application$capabili2, _urlService$locators$;
  const getUrlParams = undefined;
  const canShowDevtools = !!(application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.dev_tools) !== null && _application$capabili2 !== void 0 && _application$capabili2.show);
  const devToolsDataUri = (0, _lzString.compressToEncodedURIComponent)(request);

  // Generate a console preview link if we have a valid locator
  const consolePreviewLink = urlService === null || urlService === void 0 ? void 0 : (_urlService$locators$ = urlService.locators.get('CONSOLE_APP_LOCATOR')) === null || _urlService$locators$ === void 0 ? void 0 : _urlService$locators$.useUrl({
    loadFrom: `data:text/plain,${devToolsDataUri}`
  }, getUrlParams, [request]);

  // Check if both the Dev Tools UI and the Console UI are enabled.
  const shouldShowDevToolsLink = canShowDevtools && consolePreviewLink !== undefined;
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const codeBlockTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, (0, _extends2.default)({
    onClose: closeFlyout,
    "data-test-subj": "apiRequestFlyout",
    "aria-labelledby": flyoutTitleId
  }, flyoutProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    "data-test-subj": "apiRequestFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "apiRequestFlyoutDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: request,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "copyClipboard",
    onClick: copy,
    "data-test-subj": "apiRequestFlyoutCopyClipboardButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.viewApiRequest.copyToClipboardButton",
    defaultMessage: "Copy to clipboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  }))), shouldShowDevToolsLink && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "wrench",
    href: consolePreviewLink,
    "data-test-subj": "apiRequestFlyoutOpenInConsoleButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.viewApiRequest.openInConsoleButton",
    defaultMessage: "Open in Console",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "aria-labelledby": codeBlockTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: codeBlockTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.viewApiRequest.codeBlockTitle",
    defaultMessage: "Request code block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    "data-test-subj": "apiRequestFlyoutBody",
    overflowHeight: 1200,
    isVirtualized: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, request))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    "data-test-subj": "apiRequestFlyoutClose",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.viewApiRequest.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }))));
};
exports.ApiRequestFlyout = ApiRequestFlyout;
const ViewApiRequestFlyout = props => {
  if (props.application) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: _public.APP_WRAPPER_CLASS,
      "data-test-subj": "apiRequestFlyoutRedirectWrapper",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: {
        application: props.application
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(ApiRequestFlyout, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(ApiRequestFlyout, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 10
    }
  }));
};
exports.ViewApiRequestFlyout = ViewApiRequestFlyout;