"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cell = require("./cell");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/shared/tables/reorderable_table/header_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HeaderRow = ({
  columns,
  leftAction,
  spacingForRowIdentifier = false
}) => {
  // Calculate column index offset based on presence of leftAction and rowIdentifier
  const columnIndexOffset = (leftAction ? 1 : 0) + (spacingForRowIdentifier ? 1 : 0);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "reorderableTableHeader",
    role: "rowgroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    role: "row",
    "aria-rowindex": 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }, leftAction && /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({}, _constants.DRAGGABLE_UX_STYLE, {
    role: "columnheader",
    ariaColindex: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 15
    }
  }), leftAction), spacingForRowIdentifier && /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({}, _constants.DRAGGABLE_UX_STYLE, {
    flexBasis: "24px",
    role: "columnheader",
    ariaColindex: leftAction ? 2 : 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.reorderableTable.rowIdentifierScreenReaderOnlyLabel', {
    defaultMessage: 'Row identifier'
  })))), columns.map((column, columnIndex) => /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({
    key: `table_header_cell_${columnIndex}`
  }, column, {
    role: "columnheader",
    ariaColindex: columnIndex + columnIndexOffset + 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 19
    }
  }, column.name))))))));
};
exports.HeaderRow = HeaderRow;