"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.crawlersBreadcrumbs = exports.connectorsBreadcrumbs = exports.Connectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../shared/constants");
var _kibana = require("../../../shared/kibana");
var _table_pagination = require("../../../shared/table_pagination");
var _routes = require("../../routes");
var _layout = require("../layout");
var _default_settings_flyout = require("../settings/default_settings_flyout");
var _connector_stats = require("./connector_stats");
var _connectors_logic = require("./connectors_logic");
var _connectors_table = require("./connectors_table");
var _create_connector = require("./create_connector");
var _delete_connector_modal = require("./delete_connector_modal");
var _elastic_managed_web_crawler_empty_prompt = require("./elastic_managed_web_crawler_empty_prompt");
var _self_managed_web_crawler_empty_prompt = require("./self_managed_web_crawler_empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connectors/connectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const connectorsBreadcrumbs = exports.connectorsBreadcrumbs = [_i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.breadcrumb', {
  defaultMessage: 'Connectors'
})];
const crawlersBreadcrumbs = exports.crawlersBreadcrumbs = [_i18n.i18n.translate('xpack.enterpriseSearch.content.crawlers.breadcrumb', {
  defaultMessage: 'Web Crawlers'
})];
const Connectors = ({
  isCrawler,
  isCrawlerSelfManaged
}) => {
  const {
    fetchConnectors,
    onPaginate,
    setIsFirstRequest,
    openDeleteModal
  } = (0, _kea.useActions)(_connectors_logic.ConnectorsLogic);
  const {
    data,
    isLoading,
    searchParams,
    isEmpty,
    connectors
  } = (0, _kea.useValues)(_connectors_logic.ConnectorsLogic);
  const [searchQuery, setSearchValue] = (0, _react.useState)('');
  const [showDefaultSettingsFlyout, setShowDefaultSettingsFlyout] = (0, _react.useState)(false);
  const {
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  (0, _react.useEffect)(() => {
    setIsFirstRequest();
  }, [isCrawler]);
  (0, _react.useEffect)(() => {
    fetchConnectors({
      ...searchParams,
      fetchCrawlersOnly: isCrawler,
      searchQuery
    });
  }, [searchParams.from, searchParams.size, searchQuery, isCrawler]);
  return !isLoading && isEmpty && !isCrawler ? /*#__PURE__*/_react.default.createElement(_create_connector.CreateConnector, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_delete_connector_modal.DeleteConnectorModal, {
    isCrawler: isCrawler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchContentPageTemplate, {
    "data-test-subj": "searchConnectorsPage",
    pageChrome: !isCrawler ? connectorsBreadcrumbs : crawlersBreadcrumbs,
    pageViewTelemetry: !isCrawler ? 'Connectors' : 'Web Crawlers',
    isLoading: isLoading,
    pageHeader: {
      pageTitle: !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectors.title', {
        defaultMessage: 'Elasticsearch connectors'
      }) : _i18n.i18n.translate('xpack.enterpriseSearch.crawlers.title', {
        defaultMessage: 'Elastic Web Crawler'
      }),
      description: [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.webcrawlers.headerContent",
        defaultMessage: "Discover extract and index searchable content from websites and knowledge bases {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "entSearchContentConnectorsLearnMoreLink",
            external: true,
            target: "_blank",
            href: 'https://github.com/elastic/crawler',
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 100,
              columnNumber: 23
            }
          }, _constants.LEARN_MORE_LINK)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 17
        }
      })))],
      rightSideGroupProps: {
        gutterSize: 's',
        responsive: false
      },
      rightSideItems: isLoading ? [] : !isCrawler ? [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "entSearchContent-connectors-newConnectorButton",
        "data-telemetry-id": "entSearchContent-connectors-newConnectorButton",
        key: "newConnector",
        color: "primary",
        iconType: "plusInCircle",
        fill: true,
        onClick: () => {
          _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_SELECT_CONNECTOR_PATH);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.connectors.newConnectorButtonLabel",
        defaultMessage: "New Connector",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 23
        }
      })))), ...(productFeatures.hasDefaultIngestPipeline ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        "data-test-subj": "entSearchContent-searchIndices-defaultSettings",
        onClick: () => setShowDefaultSettingsFlyout(true),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.defaultSettings', {
        defaultMessage: 'Default settings'
      }))] : [])] : undefined
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, productFeatures.hasDefaultIngestPipeline && showDefaultSettingsFlyout && /*#__PURE__*/_react.default.createElement(_default_settings_flyout.DefaultSettingsFlyout, {
    closeFlyout: () => setShowDefaultSettingsFlyout(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  }), !isCrawler && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_stats.ConnectorStats, {
    isCrawler: isCrawler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }, isEmpty && isCrawler ? isCrawlerSelfManaged ? /*#__PURE__*/_react.default.createElement(_self_managed_web_crawler_empty_prompt.SelfManagedWebCrawlerEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_elastic_managed_web_crawler_empty_prompt.ElasticManagedWebCrawlerEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 19
    }
  }, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorsTable.h2.availableConnectorsLabel",
    defaultMessage: "Available connectors",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 23
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorsTable.h2.availableCrawlersLabel",
    defaultMessage: "Available web crawlers",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: searchQuery,
    box: {
      incremental: true,
      placeholder: !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterConnectorsPlaceholder', {
        defaultMessage: 'Filter connectors'
      }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterCrawlersPlaceholder', {
        defaultMessage: 'Filter web crawlers'
      })
    },
    "aria-label": !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterConnectorsLabel', {
      defaultMessage: 'Filter connectors'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterCrawlersLabel', {
      defaultMessage: 'Filter web crawlers'
    }),
    onChange: event => setSearchValue(event.queryText),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_connectors_table.ConnectorsTable, {
    isCrawler: isCrawler,
    items: connectors || [],
    meta: data === null || data === void 0 ? void 0 : data.meta,
    onChange: (0, _table_pagination.handlePageChange)(onPaginate),
    onDelete: openDeleteModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  })))));
};
exports.Connectors = Connectors;