"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionNotFound = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _no_ml_models_dark = _interopRequireDefault(require("../../../../assets/images/no_ml_models_dark.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_overview/analytics_collection_not_found.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ICON_WIDTH = 294;
const AnalyticsCollectionNotFound = ({
  query
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: ICON_WIDTH,
    src: _no_ml_models_dark.default,
    alt: "icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 11
    }
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.notFound.headingTitle', {
    defaultMessage: 'No results found for “{query}”',
    values: {
      query
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.notFound.subHeading', {
    defaultMessage: 'Try searching for another term.'
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 3
  }
});
exports.AnalyticsCollectionNotFound = AnalyticsCollectionNotFound;