"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamComment = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_stream = require("./use_stream");
var _stop_generating_button = require("./buttons/stop_generating_button");
var _regenerate_response_button = require("./buttons/regenerate_response_button");
var _message_panel = require("./message_panel");
var _message_text = require("./message_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/stream/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StreamComment = ({
  abortStream,
  content,
  contentReferences,
  contentReferencesVisible,
  index,
  isControlsEnabled = false,
  isError = false,
  isFetching = false,
  reader,
  refetchCurrentConversation,
  regenerateMessage,
  setIsStreaming,
  transformMessage,
  messageRole
}) => {
  const {
    error,
    isLoading,
    isStreaming,
    pendingMessage,
    setComplete
  } = (0, _use_stream.useStream)({
    refetchCurrentConversation,
    content,
    reader,
    isError
  });
  (0, _react.useEffect)(() => {
    setIsStreaming(isStreaming);
  }, [isStreaming, setIsStreaming]);
  const stopStream = (0, _react.useCallback)(() => {
    setComplete({
      complete: true,
      didAbort: true
    });
    abortStream();
  }, [abortStream, setComplete]);
  const currentState = (0, _react.useRef)({
    isStreaming,
    stopStream
  });
  (0, _react.useEffect)(() => {
    currentState.current = {
      isStreaming,
      stopStream
    };
  }, [stopStream, isStreaming]);
  (0, _react.useEffect)(() => () => {
    // if the component is unmounted while streaming, stop the stream
    if (currentState.current.isStreaming) {
      currentState.current.stopStream();
    }
  },
  // store values in currentState to detect true unmount
  []);
  const message = (0, _react.useMemo)(
  // only transform streaming message, transform happens upstream for content message
  () => content !== null && content !== void 0 ? content : transformMessage(pendingMessage).content, [content, transformMessage, pendingMessage]);
  const isAnythingLoading = (0, _react.useMemo)(() => isFetching || isLoading || isStreaming ||
  // this indicates that the message has not yet started streaming
  message.length === 0, [message, isFetching, isLoading, isStreaming]);
  const controls = (0, _react.useMemo)(() => {
    if (!isControlsEnabled) {
      return;
    }
    if (isAnythingLoading && reader) {
      return /*#__PURE__*/_react.default.createElement(_stop_generating_button.StopGeneratingButton, {
        onClick: stopStream,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_regenerate_response_button.RegenerateResponseButton, {
      onClick: regenerateMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    })));
  }, [isAnythingLoading, isControlsEnabled, reader, regenerateMessage, stopStream]);
  return /*#__PURE__*/_react.default.createElement(_message_panel.MessagePanel, {
    body: /*#__PURE__*/_react.default.createElement(_message_text.MessageText, {
      "data-test-subj": isError ? 'errorComment' : undefined,
      content: message,
      contentReferences: contentReferences,
      index: index,
      contentReferencesVisible: contentReferencesVisible,
      contentReferencesDisabled: messageRole === 'user',
      loading: isAnythingLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }),
    error: error ? new Error(error) : undefined,
    controls: controls,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  });
};
exports.StreamComment = StreamComment;