"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatternCellRenderer = void 0;
exports.getPatternCellRenderer = getPatternCellRenderer;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _esqlUtils = require("@kbn/esql-utils");
var _i18nReact = require("@kbn/i18n-react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/common/patterns/pattern_cell_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PatternCellRenderer = ({
  pattern,
  isDetails,
  defaultRowHeight
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const keywords = (0, _react.useMemo)(() => (0, _esqlUtils.extractCategorizeTokens)(pattern), [pattern]);
  const containerStyle = (0, _react.useMemo)(() => getContainerStyle(defaultRowHeight), [defaultRowHeight]);
  const formattedTokens = (0, _react.useMemo)(() => keywords.map((keyword, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      key: index,
      css: styles.keyword,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 11
      }
    }, keyword);
  }), [styles, keywords]);
  if (isDetails) {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: styles.detailsContainer,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.contextAwareness.patternCellRenderer.tokensLabel",
      defaultMessage: "Tokens",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }), formattedTokens), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.contextAwareness.patternCellRenderer.regexLabel",
      defaultMessage: "Regex",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "euiDataGridExpansionPopover-patternRegex",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }, pattern)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: containerStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 10
    }
  }, formattedTokens);
};
exports.PatternCellRenderer = PatternCellRenderer;
const componentStyles = {
  keyword: ({
    euiTheme
  }) => (0, _react2.css)({
    marginRight: euiTheme.size.xs,
    marginBottom: `calc(${euiTheme.size.m} / 2)`,
    display: 'inline-block',
    padding: `${euiTheme.size.xxs} ${euiTheme.size.s}`,
    backgroundColor: euiTheme.colors.lightestShade,
    borderRadius: euiTheme.border.radius.small,
    color: euiTheme.colors.textPrimary,
    fontSize: euiTheme.size.m
  }),
  detailsContainer: ({
    euiTheme
  }) => (0, _react2.css)({
    maxWidth: '600px'
  })
};
function getPatternCellRenderer(row, columnId, isDetails, defaultRowHeight) {
  const pattern = row.flattened[columnId];
  if (pattern === undefined) {
    return '-';
  }
  return /*#__PURE__*/_react.default.createElement(PatternCellRenderer, {
    pattern: String(pattern),
    isDetails: isDetails,
    defaultRowHeight: defaultRowHeight,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  });
}
function getContainerStyle(defaultRowHeight) {
  // the keywords are slightly larger than the default text height,
  // so they need to be adjusted to fit within the row height while
  // not truncating the bottom of the text
  let rowHeight = 2;
  if (defaultRowHeight === undefined) {
    rowHeight = 2;
  } else if (defaultRowHeight < 2) {
    rowHeight = 1;
  } else {
    rowHeight = Math.floor(defaultRowHeight / 1.5);
  }
  return {
    display: '-webkit-box',
    WebkitBoxOrient: 'vertical',
    WebkitLineClamp: rowHeight,
    overflow: 'hidden',
    textOverflow: 'ellipsis'
  };
}