"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Doc = Doc;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _breadcrumbs = require("../../../utils/breadcrumbs");
var _use_discover_services = require("../../../hooks/use_discover_services");
var _single_doc_viewer = require("./single_doc_viewer");
var _data_sources = require("../../../../common/data_sources");
var _scoped_services_provider = require("../../../components/scoped_services_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/doc/components/doc.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Doc(props) {
  const {
    dataView
  } = props;
  const {
    scopedProfilesManager
  } = (0, _scoped_services_provider.useScopedServices)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    locator,
    chrome,
    docLinks
  } = services;
  const indexExistsLink = docLinks.links.apis.indexExists;
  const onBeforeFetch = (0, _react.useCallback)(async () => {
    await scopedProfilesManager.resolveDataSourceProfile({
      dataSource: dataView !== null && dataView !== void 0 && dataView.id ? (0, _data_sources.createDataViewDataSource)({
        dataViewId: dataView.id
      }) : undefined,
      dataView,
      query: {
        query: '',
        language: 'kuery'
      }
    });
  }, [scopedProfilesManager, dataView]);
  const onProcessRecord = (0, _react.useCallback)(record => {
    return scopedProfilesManager.resolveDocumentProfile({
      record
    });
  }, [scopedProfilesManager]);
  const [reqState, record] = (0, _public.useEsDocSearch)({
    ...props,
    onBeforeFetch,
    onProcessRecord
  });
  (0, _react.useEffect)(() => {
    (0, _breadcrumbs.setBreadcrumbs)({
      services,
      titleBreadcrumbText: `${props.index}#${props.id}`,
      rootBreadcrumbPath: props.referrer
    });
  }, [chrome, props.referrer, props.index, props.id, dataView, locator, services]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "singleDocTitle",
    className: "euiScreenReaderOnly",
    "data-test-subj": "discoverSingleDocTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('discover.doc.pageTitle', {
    defaultMessage: 'Single document - #{id}',
    values: {
      id: props.id
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true,
    paddingSize: "m",
    panelProps: {
      role: 'main'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, reqState === _unifiedDocViewer.ElasticRequestState.NotFoundDataView && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": `doc-msg-notFoundDataView`,
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.doc.failedToLocateDataView",
      defaultMessage: "No data view matches ID {dataViewId}.",
      values: {
        dataViewId: dataView.id
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }), reqState === _unifiedDocViewer.ElasticRequestState.NotFound && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": `doc-msg-notFound`,
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.doc.failedToLocateDocumentDescription",
      defaultMessage: "Cannot find document",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.doc.couldNotFindDocumentsDescription",
    defaultMessage: "No documents match that ID.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  })), reqState === _unifiedDocViewer.ElasticRequestState.Error && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": `doc-msg-error`,
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.doc.failedToExecuteQueryDescription",
      defaultMessage: "Cannot run search",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.doc.somethingWentWrongDescription",
    defaultMessage: "{indexName} is missing.",
    values: {
      indexName: props.index
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: indexExistsLink,
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.doc.somethingWentWrongDescriptionAddon",
    defaultMessage: "Please ensure the index exists.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }))), reqState === _unifiedDocViewer.ElasticRequestState.Loading && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": `doc-msg-loading`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.doc.loadingDescription",
    defaultMessage: "Loading\u2026",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  })), reqState === _unifiedDocViewer.ElasticRequestState.Found && record !== null && dataView && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "doc-hit",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_single_doc_viewer.SingleDocViewer, {
    record: record,
    dataView: dataView,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }))));
}