"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerFieldTypeFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _fieldUtils = require("@kbn/field-utils");
var _field_types_help_popover = require("../../../common/components/field_types_filter/field_types_help_popover");
var _field_type_icon = require("../../../common/components/field_type_icon");
var _multi_select_picker = require("../../../common/components/multi_select_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/components/search_panel/field_type_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataVisualizerFieldTypeFilter = ({
  indexedFieldTypes,
  setVisibleFieldTypes,
  visibleFieldTypes
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const options = (0, _react.useMemo)(() => {
    return indexedFieldTypes.map(indexedFieldName => {
      var _getFieldTypeName;
      const label = (_getFieldTypeName = (0, _fieldUtils.getFieldTypeName)(indexedFieldName)) !== null && _getFieldTypeName !== void 0 ? _getFieldTypeName : indexedFieldName;
      return {
        value: indexedFieldName,
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 32,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 33,
            columnNumber: 13
          }
        }, " ", label), indexedFieldName && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 35,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_field_type_icon.FieldTypeIcon, {
          type: indexedFieldName,
          tooltipEnabled: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 36,
            columnNumber: 17
          }
        })))
      };
    });
  }, [indexedFieldTypes]);
  const fieldTypeTitle = (0, _react.useMemo)(() => _i18n.i18n.translate('xpack.dataVisualizer.index.fieldTypeSelect', {
    defaultMessage: 'Field type'
  }), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_select_picker.MultiSelectPicker, {
    title: fieldTypeTitle,
    options: options,
    onChange: setVisibleFieldTypes,
    checkedOptions: visibleFieldTypes,
    dataTestSubj: 'dataVisualizerFieldTypeSelect',
    postfix: /*#__PURE__*/_react.default.createElement(_field_types_help_popover.FieldTypesHelpPopover, {
      fieldTypes: indexedFieldTypes,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 18
      }
    }),
    cssStyles: {
      filterGroup: (0, _react2.css)`
            margin-left: ${euiTheme.size.s};
          `
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }));
};
exports.DataVisualizerFieldTypeFilter = DataVisualizerFieldTypeFilter;