"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleAlertCommentEvent = exports.MultipleAlertsCommentEvent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _links = require("../../links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/comment/alert_event.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleLink = /*#__PURE__*/(0, _react.memo)(({
  onRuleDetailsClick,
  getRuleDetailsHref,
  ruleId,
  ruleName,
  loadingAlertData,
  actionId
}) => {
  const onLinkClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    if (onRuleDetailsClick) onRuleDetailsClick(ruleId, ev);
  }, [ruleId, onRuleDetailsClick]);
  const ruleDetailsHref = getRuleDetailsHref === null || getRuleDetailsHref === void 0 ? void 0 : getRuleDetailsHref(ruleId);
  const finalRuleName = ruleName !== null && ruleName !== void 0 ? ruleName : i18n.UNKNOWN_RULE;
  const isValidLink = (0, _react.useMemo)(() => {
    if (!onRuleDetailsClick && !ruleDetailsHref) {
      return false;
    }
    return !(0, _lodash.isEmpty)(ruleId);
  }, [onRuleDetailsClick, ruleDetailsHref, ruleId]);
  if (loadingAlertData) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": `alert-loading-spinner-${actionId}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 14
      }
    });
  }
  if (isValidLink) {
    return /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
      onClick: onLinkClick,
      href: ruleDetailsHref,
      "data-test-subj": `alert-rule-link-${actionId}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, finalRuleName);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, finalRuleName);
});
RuleLink.displayName = 'RuleLink';
const SingleAlertCommentEventComponent = ({
  actionId,
  getRuleDetailsHref,
  loadingAlertData = false,
  onRuleDetailsClick,
  ruleId,
  ruleName
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `single-alert-user-action-${actionId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, `${i18n.ALERT_COMMENT_LABEL_TITLE} `, /*#__PURE__*/_react.default.createElement(RuleLink, {
    actionId: actionId,
    ruleId: ruleId,
    ruleName: ruleName,
    getRuleDetailsHref: getRuleDetailsHref,
    onRuleDetailsClick: onRuleDetailsClick,
    loadingAlertData: loadingAlertData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }));
};
SingleAlertCommentEventComponent.displayName = 'SingleAlertCommentEvent';
const SingleAlertCommentEvent = exports.SingleAlertCommentEvent = /*#__PURE__*/(0, _react.memo)(SingleAlertCommentEventComponent);
const MultipleAlertsCommentEventComponent = ({
  actionId,
  getRuleDetailsHref,
  loadingAlertData = false,
  onRuleDetailsClick,
  ruleId,
  ruleName,
  totalAlerts
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `multiple-alerts-user-action-${actionId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, `${i18n.MULTIPLE_ALERTS_COMMENT_LABEL_TITLE(totalAlerts)}`, ' ', /*#__PURE__*/_react.default.createElement(RuleLink, {
    actionId: actionId,
    ruleId: ruleId,
    ruleName: ruleName,
    getRuleDetailsHref: getRuleDetailsHref,
    onRuleDetailsClick: onRuleDetailsClick,
    loadingAlertData: loadingAlertData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }));
};
MultipleAlertsCommentEventComponent.displayName = 'MultipleAlertsCommentEvent';
const MultipleAlertsCommentEvent = exports.MultipleAlertsCommentEvent = /*#__PURE__*/(0, _react.memo)(MultipleAlertsCommentEventComponent);