"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.font = exports.FontArgInput = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _fonts = require("../../../common/lib/fonts");
var _template_from_react_component = require("../../lib/template_from_react_component");
var _text_style_picker = require("../../components/text_style_picker");
var _i18n = require("../../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/expression_types/arg_types/font.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  Font: strings
} = _i18n.ArgTypesStrings;
const FontArgInput = props => {
  const {
    onValueChange,
    argValue,
    workpad
  } = props;
  const chain = (0, _lodash.get)(argValue, 'chain.0', {});
  const chainArgs = (0, _lodash.get)(chain, 'arguments', {});

  // TODO: Validate input

  const spec = (0, _lodash.mapValues)(chainArgs, '[0]');
  function handleChange(newSpec) {
    const newValue = (0, _saferLodashSet.set)(argValue, ['chain', 0, 'arguments'], (0, _lodash.mapValues)(newSpec, v => [v]));
    return onValueChange(newValue);
  }
  return /*#__PURE__*/_react.default.createElement(_text_style_picker.TextStylePicker, {
    family: spec.family,
    color: spec.color,
    size: spec.size,
    align: spec.align,
    weight: spec.weight,
    underline: spec.underline || false,
    italic: spec.italic || false,
    onChange: handleChange,
    colors: workpad.colors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
};
exports.FontArgInput = FontArgInput;
FontArgInput.propTypes = {
  onValueChange: _propTypes.default.func.isRequired,
  argValue: _propTypes.default.any.isRequired,
  typeInstance: _propTypes.default.object,
  workpad: _propTypes.default.shape({
    colors: _propTypes.default.array.isRequired
  }).isRequired
};
FontArgInput.displayName = 'FontArgInput';
const font = () => ({
  name: 'font',
  displayName: strings.getDisplayName(),
  help: strings.getHelp(),
  template: (0, _template_from_react_component.templateFromReactComponent)(FontArgInput),
  default: `{font size=14 family="${_fonts.openSans.value}" color="#000000" align=left}`
});
exports.font = font;