"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementGrid = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _element_controls = require("./element_controls");
var _element_card = require("../element_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/saved_elements_modal/element_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ElementGrid = ({
  elements,
  filterText,
  onClick,
  onEdit,
  onDelete
}) => {
  filterText = filterText.toLowerCase();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, (0, _lodash.map)(elements, (element, index) => {
    const {
      name,
      displayName = '',
      help = '',
      image
    } = element;
    const whenClicked = () => onClick(element);
    if (filterText.length && !name.toLowerCase().includes(filterText) && !displayName.toLowerCase().includes(filterText) && !help.toLowerCase().includes(filterText)) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      className: "canvasElementCard__wrapper",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_element_card.ElementCard, {
      title: displayName || name,
      description: help,
      image: image,
      onClick: whenClicked,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_element_controls.ElementControls, {
      onEdit: () => onEdit(element),
      onDelete: () => onDelete(element),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 13
      }
    }));
  }));
};
exports.ElementGrid = ElementGrid;
ElementGrid.propTypes = {
  elements: _propTypes.default.array.isRequired,
  filterText: _propTypes.default.string.isRequired,
  onClick: _propTypes.default.func.isRequired,
  onEdit: _propTypes.default.func.isRequired,
  onDelete: _propTypes.default.func.isRequired
};
ElementGrid.defaultProps = {
  filterText: ''
};