"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIntegration = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _telemetry = require("./telemetry");
var _create_integration_landing = require("./create_integration_landing");
var _create_integration_upload = require("./create_integration_upload");
var _constants = require("../../common/constants");
var _use_authorization = require("../../common/hooks/use_authorization");
var _use_availability = require("../../common/hooks/use_availability");
var _create_automatic_import = require("./create_automatic_import");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_integration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CreateIntegration = exports.CreateIntegration = /*#__PURE__*/_react.default.memo(({
  services
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_telemetry.TelemetryContextProvider, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(CreateIntegrationRouter, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 7
  }
}))));
CreateIntegration.displayName = 'CreateIntegration';
const CreateIntegrationRouter = /*#__PURE__*/_react.default.memo(() => {
  const {
    canUseAutomaticImport,
    canUseIntegrationUpload
  } = (0, _use_authorization.useRoutesAuthorization)();
  const isAvailable = (0, _use_availability.useIsAvailable)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, isAvailable && canUseAutomaticImport && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.PagePath[_constants.Page.assistant],
    exact: true,
    component: _create_automatic_import.CreateAutomaticImport,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }), isAvailable && canUseIntegrationUpload && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.PagePath[_constants.Page.upload],
    exact: true,
    component: _create_integration_upload.CreateIntegrationUpload,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.PagePath[_constants.Page.landing],
    exact: true,
    component: _create_integration_landing.CreateIntegrationLanding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.PagePath[_constants.Page.landing],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 28
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }));
});
CreateIntegrationRouter.displayName = 'CreateIntegrationRouter';