"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraLink = InfraLink;
exports.getInfraHref = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _url = _interopRequireDefault(require("url"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _url_helpers = require("./url_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/infra_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getInfraHref = ({
  app,
  basePath,
  query,
  path
}) => {
  const nextSearch = (0, _url_helpers.fromQuery)(query);
  return _url.default.format({
    pathname: basePath.prepend(`/app/${app}${path || ''}`),
    search: nextSearch
  });
};
exports.getInfraHref = getInfraHref;
function InfraLink({
  app,
  path,
  query = {},
  ...rest
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const href = getInfraHref({
    app,
    basePath: core.http.basePath,
    query,
    path
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmInfraLinkLink"
  }, rest, {
    href: href,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 10
    }
  }));
}