"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Controls = Controls;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _apm_link_hooks = require("../../shared/links/apm/apm_link_hooks");
var _use_url_params = require("../../../context/url_params_context/use_url_params");
var _cytoscape = require("./cytoscape");
var _cytoscape_options = require("./cytoscape_options");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ControlsContainer = (0, _styled.default)('div')`
  left: ${({
  theme
}) => theme.euiTheme.size.base};
  position: absolute;
  top: ${({
  theme
}) => theme.euiTheme.size.s};
  z-index: 1; /* The element containing the cytoscape canvas has z-index = 0. */
`;
const Button = (0, _styled.default)(_eui.EuiButtonIcon)`
  display: block;
  margin: ${({
  theme
}) => theme.euiTheme.size.xs};
`;
const ZoomInButton = (0, _styled.default)(Button)`
  margin-bottom: ${({
  theme
}) => theme.euiTheme.size.s};
`;
const Panel = (0, _styled.default)(_eui.EuiPanel)`
  margin-bottom: ${({
  theme
}) => theme.euiTheme.size.s};
`;
const steps = 5;
function doZoom(cy, increment, duration) {
  if (cy) {
    const level = cy.zoom() + increment;
    // @ts-expect-error `.position()` _does_ work on a NodeCollection. It returns the position of the first element in the collection.
    const primaryCenter = cy.nodes('.primary').position();
    const {
      x1,
      y1,
      w,
      h
    } = cy.nodes().boundingBox({});
    const graphCenter = {
      x: x1 + w / 2,
      y: y1 + h / 2
    };
    cy.animate({
      duration,
      zoom: {
        level,
        position: primaryCenter || graphCenter
      }
    });
  }
}
function useDebugDownloadUrl(cy) {
  const [downloadUrl, setDownloadUrl] = (0, _react.useState)(undefined);
  const debug = sessionStorage.getItem('apm_debug') === 'true';

  // Handle elements changes to update the download URL
  (0, _react.useEffect)(() => {
    const elementsHandler = event => {
      var _event$cy$json;
      // @ts-expect-error The `true` argument to `cy.json` is to flatten the elements
      // (instead of having them broken into nodes/edges.) DefinitelyTyped has
      // this wrong.
      const elementsJson = (_event$cy$json = event.cy.json(true)) === null || _event$cy$json === void 0 ? void 0 : _event$cy$json.elements.map(element => ({
        data: element.data
      }));
      setDownloadUrl(elementsJson.length > 0 && debug ? `data:application/json;charset=utf-8,${encodeURIComponent(JSON.stringify({
        elements: elementsJson
      }, null, '  '))}` : undefined);
    };
    if (cy) {
      cy.on('add remove', elementsHandler);
    }
    return () => {
      if (cy) {
        cy.off('add remove', elementsHandler);
      }
    };
  }, [cy, debug]);
  return downloadUrl;
}
function Controls() {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    basePath
  } = core.http;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cy = (0, _react.useContext)(_cytoscape.CytoscapeContext);
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    query: {
      kuery
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/service-map', '/services/{serviceName}/service-map', '/mobile-services/{serviceName}/service-map');
  const [zoom, setZoom] = (0, _react.useState)(cy && cy.zoom() || 1);
  const duration = euiTheme.animation.fast ? parseInt(euiTheme.animation.fast, 10) : 0;
  const downloadUrl = useDebugDownloadUrl(cy);
  const viewFullMapUrl = (0, _apm_link_hooks.getLegacyApmHref)({
    basePath,
    path: '/service-map',
    search: `kuery=${encodeURIComponent(kuery)}`,
    query: urlParams
  });

  // Handle zoom events
  (0, _react.useEffect)(() => {
    const zoomHandler = event => {
      setZoom(event.cy.zoom());
    };
    if (cy) {
      cy.on('zoom', zoomHandler);
    }
    return () => {
      if (cy) {
        cy.off('zoom', zoomHandler);
      }
    };
  }, [cy]);
  function center() {
    if (cy) {
      const eles = cy.nodes();
      cy.animate({
        ...(0, _cytoscape_options.getAnimationOptions)(euiTheme),
        center: {
          eles
        },
        fit: {
          eles,
          padding: (0, _cytoscape_options.getNodeHeight)(euiTheme)
        }
      });
    }
  }
  function zoomIn() {
    doZoom(cy, increment, duration);
  }
  function zoomOut() {
    doZoom(cy, -increment, duration);
  }
  if (!cy) {
    return null;
  }
  const maxZoom = cy.maxZoom();
  const isMaxZoom = zoom === maxZoom;
  const minZoom = cy.minZoom();
  const isMinZoom = zoom === minZoom;
  const increment = (maxZoom - minZoom) / steps;
  const centerLabel = _i18n.i18n.translate('xpack.apm.serviceMap.center', {
    defaultMessage: 'Center'
  });
  const downloadLabel = _i18n.i18n.translate('xpack.apm.serviceMap.download', {
    defaultMessage: 'Download'
  });
  const viewFullMapLabel = _i18n.i18n.translate('xpack.apm.serviceMap.viewFullMap', {
    defaultMessage: 'View full service map'
  });
  const zoomInLabel = _i18n.i18n.translate('xpack.apm.serviceMap.zoomIn', {
    defaultMessage: 'Zoom in'
  });
  const zoomOutLabel = _i18n.i18n.translate('xpack.apm.serviceMap.zoomOut', {
    defaultMessage: 'Zoom out'
  });
  const showViewFullMapButton = cy.nodes('.primary').length > 0;
  return /*#__PURE__*/_react.default.createElement(ControlsContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Panel, {
    hasShadow: true,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: "eui-displayInline",
    content: zoomInLabel,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ZoomInButton, {
    "aria-label": zoomInLabel,
    color: "text",
    disabled: isMaxZoom,
    iconType: "plusInCircleFilled",
    onClick: zoomIn,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: "eui-displayInline",
    content: zoomOutLabel,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(Button, {
    "aria-label": zoomOutLabel,
    color: "text",
    disabled: isMinZoom,
    iconType: "minusInCircleFilled",
    onClick: zoomOut,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(Panel, {
    hasShadow: true,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: "eui-displayInline",
    content: centerLabel,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(Button, {
    "data-test-subj": "centerServiceMap",
    "aria-label": centerLabel,
    color: "text",
    iconType: "crosshairs",
    onClick: center,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  }))), showViewFullMapButton && /*#__PURE__*/_react.default.createElement(Panel, {
    hasShadow: true,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: "eui-displayInline",
    content: viewFullMapLabel,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(Button, {
    "aria-label": viewFullMapLabel,
    color: "text",
    "data-test-subj": "viewFullMapButton",
    href: viewFullMapUrl,
    iconType: "apps",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }))), downloadUrl && /*#__PURE__*/_react.default.createElement(Panel, {
    hasShadow: true,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: "eui-displayInline",
    content: downloadLabel,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(Button, {
    "aria-label": downloadLabel,
    color: "text",
    download: "service-map.json",
    href: downloadUrl,
    iconType: "download",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 13
    }
  }))));
}