"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyDashboards = EmptyDashboards;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedSvg = require("@kbn/shared-svg");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_dashboards/empty_dashboards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EmptyDashboards({
  actions
}) {
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    hasShadow: false,
    hasBorder: false,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: isDarkMode ? _sharedSvg.dashboardsDark : _sharedSvg.dashboardsLight,
      alt: "",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 11
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyTitle', {
      defaultMessage: 'The best way to understand your data is to visualize it.'
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyBody.first', {
      defaultMessage: 'bring clarity to your data'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyBody.second', {
      defaultMessage: 'tell a story about your data'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyBody', {
      defaultMessage: 'focus on only the data that’s important to you'
    }))), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyBody.getStarted', {
      defaultMessage: 'To get started, add your dashboard'
    }))),
    actions: actions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 7
    }
  }));
}