"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHighlightStyles = void 0;
var _react = require("@emotion/react");
var _track_panel = require("../../dashboard_api/track_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const borderSpinKeyframes = (0, _react.keyframes)({
  '0%': {
    '--highlight-rotate': '0deg',
    opacity: 0
  },
  '10%, 60%': {
    opacity: 1
  },
  '100%': {
    '--highlight-rotate': '180deg',
    opacity: 0
  }
});
const getOutlineFadeKeyframes = ({
  euiTheme
}) => (0, _react.keyframes)({
  '0%, 70%': {
    outline: `${euiTheme.border.width.thin} dashed transparent`
  },
  '100%': {
    outline: `${euiTheme.border.width.thin} dashed ${euiTheme.colors.borderBaseFormsControl}`
  }
});
const shineKeyframes = (0, _react.keyframes)({
  '0%': {
    '--highlight-rotate': '0deg',
    opacity: 0
  },
  '10%': {
    opacity: 0.7
  },
  '100%': {
    '--highlight-rotate': '180deg',
    opacity: 0
  }
});
const highlightPropertyStyles = (0, _react.css)`
  @property --highlight-rotate {
    syntax: '<angle>';
    inherits: false;
    initial-value: 0deg;
  }
`;
const getHighlightStyles = context => {
  const {
    euiTheme
  } = context;
  const rotatingGradient = `
    linear-gradient(var(--highlight-rotate), 
    ${euiTheme.colors.borderBaseSuccess} 0%,
    ${euiTheme.colors.borderBaseAccent} 46%,
    ${euiTheme.colors.borderBaseAccentSecondary} 100%
  )`;
  const brightenInDarkMode = brightness => context.colorMode === 'DARK' ? `brightness(${brightness})` : '';
  return (0, _react.css)([highlightPropertyStyles, {
    '&.dshDashboardGrid__item--highlighted .embPanel': {
      position: 'relative',
      overflow: 'visible !important',
      backgroundColor: euiTheme.colors.backgroundBasePlain,
      animation: `${getOutlineFadeKeyframes(context)} ${_track_panel.highlightAnimationDuration}ms ease-out`
    },
    '&.dshDashboardGrid__item--highlighted .embPanel::before': {
      content: `""`,
      opacity: 0,
      position: 'absolute',
      left: '-5px',
      top: '-5px',
      'z-index': -1,
      width: 'calc(100% + 10px)',
      height: 'calc(100% + 10px)',
      backgroundImage: rotatingGradient,
      filter: brightenInDarkMode(1.5),
      borderRadius: euiTheme.border.radius.medium,
      animation: `${borderSpinKeyframes} ${_track_panel.highlightAnimationDuration}ms ease-out`
    },
    '&.dshDashboardGrid__item--highlighted .embPanel::after': {
      content: `""`,
      opacity: 0,
      position: 'absolute',
      left: '-15px',
      top: '-15px',
      'z-index': -2,
      width: 'calc(100% + 30px)',
      height: 'calc(100% + 30px)',
      backgroundImage: rotatingGradient,
      filter: `${brightenInDarkMode(1.3)} blur(25px)`,
      animation: `${shineKeyframes} ${_track_panel.highlightAnimationDuration}ms ease-out`
    }
  }]);
};
exports.getHighlightStyles = getHighlightStyles;