"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalToastList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _server = require("react-dom/server");
var _i18n = require("@kbn/i18n");
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _deduplicate_toasts = require("./deduplicate_toasts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/notifications/browser-internal/src/toasts/global_toast_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const convertToEui = toast => ({
  ...toast,
  title: toast.title instanceof Function ? /*#__PURE__*/_react.default.createElement(_coreMountUtilsBrowserInternal.MountWrapper, {
    mount: toast.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 44
    }
  }) : toast.title,
  text: toast.text instanceof Function ? /*#__PURE__*/_react.default.createElement(_coreMountUtilsBrowserInternal.MountWrapper, {
    mount: toast.text,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 42
    }
  }) : toast.text
});
const GlobalToastList = ({
  toasts$,
  dismissToast,
  reportEvent
}) => {
  const [toasts, setToasts] = (0, _react.useState)([]);
  const [idToToasts, setIdToToasts] = (0, _react.useState)({});
  const reportToastDismissal = (0, _react.useCallback)(representedToasts => {
    // Select the first duplicate toast within the represented toast group
    // given it's identical to all other recurring ones within it's group
    const firstDuplicateToast = representedToasts[0];
    if (representedToasts.length > 1 && firstDuplicateToast.color !== 'success' && firstDuplicateToast.title) {
      reportEvent.onDismissToast({
        toastMessage: firstDuplicateToast.title instanceof Function ? (0, _server.renderToStaticMarkup)(/*#__PURE__*/_react.default.createElement(_coreMountUtilsBrowserInternal.MountWrapper, {
          mount: firstDuplicateToast.title,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 38
          }
        })) : firstDuplicateToast.title,
        recurrenceCount: representedToasts.length,
        toastMessageType: firstDuplicateToast.color
      });
    }
  }, [reportEvent]);
  (0, _react.useEffect)(() => {
    const subscription = toasts$.subscribe(redundantToastList => {
      const {
        toasts: reducedToasts,
        idToToasts: reducedIdToasts
      } = (0, _deduplicate_toasts.deduplicateToasts)(redundantToastList);
      setIdToToasts(reducedIdToasts);
      setToasts(reducedToasts);
    });
    return () => subscription.unsubscribe();
  }, [reportEvent, toasts$]);
  const closeToastsRepresentedById = (0, _react.useCallback)(({
    id
  }) => {
    const representedToasts = idToToasts[id];
    if (representedToasts) {
      representedToasts.forEach(toast => dismissToast(toast.id));
      reportToastDismissal(representedToasts);
    }
  }, [dismissToast, idToToasts, reportToastDismissal]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiGlobalToastList, {
    "aria-label": _i18n.i18n.translate('core.notifications.globalToast.ariaLabel', {
      defaultMessage: 'Notification message list'
    }),
    "data-test-subj": "globalToastList",
    toasts: toasts.map(convertToEui),
    dismissToast: closeToastsRepresentedById
    /**
     * This prop is overridden by the individual toasts that are added.
     * Use `Infinity` here so that it's obvious a timeout hasn't been
     * provided in development.
     */,
    toastLifeTimeMs: Infinity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  });
};
exports.GlobalToastList = GlobalToastList;