"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Benchmarks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/fleet-plugin/public");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _use_csp_setup_status_api = require("@kbn/cloud-security-posture/src/hooks/use_csp_setup_status_api");
var _constants = require("../../../common/constants");
var _cloud_posture_page_title = require("../../components/cloud_posture_page_title");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _benchmarks_table = require("./benchmarks_table");
var _use_csp_benchmark_integrations = require("./use_csp_benchmark_integrations");
var _helpers = require("../../../common/utils/helpers");
var TEST_SUBJ = _interopRequireWildcard(require("./test_subjects"));
var _constants2 = require("../../common/constants");
var _use_page_size = require("../../common/hooks/use_page_size");
var _use_kibana = require("../../common/hooks/use_kibana");
var _no_findings_states = require("../../components/no_findings_states");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/benchmarks/benchmarks.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SEARCH_DEBOUNCE_MS = 300;
const AddCisIntegrationButton = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const integrationsPath = _public.pagePathGetters.integrations_all({
    searchTerm: _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME
  }).join('');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": TEST_SUBJ.ADD_INTEGRATION_TEST_SUBJ,
    fill: true,
    iconType: "plusInCircle",
    href: http.basePath.prepend(integrationsPath),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.benchmarks.benchmarksPageHeader.addIntegrationButtonLabel",
    defaultMessage: "Add Integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
const BenchmarkEmptyState = ({
  name
}) => /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("strong", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.benchmarks.benchmarkEmptyState.rulesNotFoundTitle",
  defaultMessage: "No benchmark rules found",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 11
  }
}), name && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.benchmarks.benchmarkEmptyState.integrationsNotFoundForNameTitle",
  defaultMessage: " for \"{name}\"",
  values: {
    name
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 13
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 89,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.benchmarks.benchmarkEmptyState.rulesNotFoundWithFiltersTitle",
  defaultMessage: "We weren't able to find any benchmark rules with the above filters.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 5
  }
}));
const TotalIntegrationsCount = ({
  pageCount,
  totalCount
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  css: {
    marginLeft: 8
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 106,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 107,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.benchmarks.totalIntegrationsCountMessage",
  defaultMessage: "Showing {pageCount} of {totalCount, plural, one {# benchmark} other {# benchmarks}}",
  values: {
    pageCount,
    totalCount
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 108,
    columnNumber: 7
  }
})));
const SearchAnnouncement = ({
  resultCount,
  searchValue
}) => {
  const liveRegionRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (liveRegionRef.current) {
      liveRegionRef.current.textContent = searchValue ? _i18n.i18n.translate('xpack.csp.benchmarks.searchResultAnnouncementWithQuery', {
        defaultMessage: '{resultCount} benchmark table results found for "{searchValue}"',
        values: {
          resultCount,
          searchValue
        }
      }) : _i18n.i18n.translate('xpack.csp.benchmarks.searchResultAnnouncementWithoutQuery', {
        defaultMessage: '{resultCount} total benchmarks',
        values: {
          resultCount
        }
      });
    }
  }, [resultCount, searchValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "aria-live": "polite",
    "aria-atomic": "true",
    ref: liveRegionRef,
    role: "status",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }));
};
const BenchmarkSearchField = ({
  onSearch,
  isLoading
}) => {
  const [localValue, setLocalValue] = (0, _react.useState)('');
  (0, _useDebounce.default)(() => onSearch(localValue), SEARCH_DEBOUNCE_MS, [localValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: {
      alignItems: 'flex-end'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    onSearch: setLocalValue,
    isLoading: isLoading,
    placeholder: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarkSearchField.searchPlaceholder', {
      defaultMessage: 'Search by Benchmark Name'
    }),
    incremental: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  })));
};
const Benchmarks = () => {
  var _queryResult$data, _queryResult$data2, _getSetupStatus$data, _getSetupStatus$data$, _getSetupStatus$data2, _getSetupStatus$data3, _queryResult$data3;
  const {
    pageSize,
    setPageSize
  } = (0, _use_page_size.usePageSize)(_constants2.LOCAL_STORAGE_PAGE_SIZE_BENCHMARK_KEY);
  const [query, setQuery] = (0, _react.useState)({
    name: '',
    page: 1,
    perPage: pageSize,
    sortField: 'package_policy.name',
    sortOrder: 'asc'
  });
  const queryResult = (0, _use_csp_benchmark_integrations.useCspBenchmarkIntegrationsV2)();
  const lowerCaseQueryName = query.name.toLowerCase();
  const benchmarkResult = ((_queryResult$data = queryResult.data) === null || _queryResult$data === void 0 ? void 0 : _queryResult$data.items.filter(obj => {
    var _getBenchmarkCisName;
    return (_getBenchmarkCisName = (0, _helpers.getBenchmarkCisName)(obj.id)) === null || _getBenchmarkCisName === void 0 ? void 0 : _getBenchmarkCisName.toLowerCase().includes(lowerCaseQueryName);
  })) || [];
  const totalItemCount = ((_queryResult$data2 = queryResult.data) === null || _queryResult$data2 === void 0 ? void 0 : _queryResult$data2.items.length) || 0;

  // Check if we have any CSP Integration or not
  const getSetupStatus = (0, _use_csp_setup_status_api.useCspSetupStatusApi)({
    refetchInterval: _constants2.NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS
  });
  const kspmStatus = (_getSetupStatus$data = getSetupStatus.data) === null || _getSetupStatus$data === void 0 ? void 0 : (_getSetupStatus$data$ = _getSetupStatus$data.kspm) === null || _getSetupStatus$data$ === void 0 ? void 0 : _getSetupStatus$data$.status;
  const cspmStatus = (_getSetupStatus$data2 = getSetupStatus.data) === null || _getSetupStatus$data2 === void 0 ? void 0 : (_getSetupStatus$data3 = _getSetupStatus$data2.cspm) === null || _getSetupStatus$data3 === void 0 ? void 0 : _getSetupStatus$data3.status;
  const showNoFindingsStates = kspmStatus === 'not-installed' && cspmStatus === 'not-installed' || cspmStatus === 'unprivileged' || kspmStatus === 'unprivileged';
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": TEST_SUBJ.BENCHMARKS_PAGE_HEADER,
    pageTitle: /*#__PURE__*/_react.default.createElement(_cloud_posture_page_title.CloudPosturePageTitle, {
      title: _i18n.i18n.translate('xpack.csp.benchmarks.benchmarksPageHeader.benchmarksTitle', {
        defaultMessage: 'Benchmarks'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 11
      }
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(AddCisIntegrationButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 26
      }
    })],
    bottomBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }), showNoFindingsStates ? /*#__PURE__*/_react.default.createElement(_no_findings_states.NoFindingsStates, {
    postureType: 'all',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(BenchmarkSearchField, {
    isLoading: queryResult.isFetching,
    onSearch: name => setQuery(current => ({
      ...current,
      name
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(TotalIntegrationsCount, {
    pageCount: (((_queryResult$data3 = queryResult.data) === null || _queryResult$data3 === void 0 ? void 0 : _queryResult$data3.items) || []).length,
    totalCount: totalItemCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(SearchAnnouncement, {
    resultCount: benchmarkResult.length,
    searchValue: query.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_benchmarks_table.BenchmarksTable, {
    benchmarks: benchmarkResult,
    "data-test-subj": TEST_SUBJ.BENCHMARKS_TABLE_DATA_TEST_SUBJ,
    error: queryResult.error ? (0, _cloudSecurityPostureCommon.extractErrorMessage)(queryResult.error) : undefined,
    loading: queryResult.isFetching,
    pageIndex: query.page,
    pageSize: pageSize || query.perPage,
    sorting: {
      // @ts-expect-error - EUI types currently do not support sorting by nested fields
      sort: {
        field: query.sortField,
        direction: query.sortOrder
      },
      allowNeutralSort: false
    },
    totalItemCount: totalItemCount,
    setQuery: ({
      page,
      sort
    }) => {
      setPageSize(page.size);
      setQuery(current => ({
        ...current,
        page: page.index,
        perPage: page.size,
        sortField: (sort === null || sort === void 0 ? void 0 : sort.field) || current.sortField,
        sortOrder: (sort === null || sort === void 0 ? void 0 : sort.direction) || current.sortOrder
      }));
    },
    noItemsMessage: queryResult.isSuccess ? /*#__PURE__*/_react.default.createElement(BenchmarkEmptyState, {
      name: query.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 39
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  })));
};
exports.Benchmarks = Benchmarks;