"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionsSelect = SuggestionsSelect;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/suggestions_select/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SuggestionsSelect({
  customOptions,
  customOptionText,
  defaultValue,
  fieldName,
  start,
  end,
  onChange,
  placeholder,
  isInvalid,
  dataTestSubj,
  isClearable = true,
  prepend,
  serviceName,
  shouldReset = false
}) {
  var _data$terms;
  let defaultOption;
  if (defaultValue) {
    defaultOption = {
      label: defaultValue,
      value: defaultValue
    };
  }
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(defaultOption ? [defaultOption] : []);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/suggestions', {
      params: {
        query: {
          fieldName,
          fieldValue: searchValue,
          start,
          end,
          serviceName
        }
      }
    });
  }, [fieldName, searchValue, start, end, serviceName], {
    preservePreviousData: false
  });

  // Track previous shouldReset to only reset on transition from false to true
  const prevShouldResetRef = (0, _react.useRef)(shouldReset);

  // Reset when shouldReset transitions from false to true
  (0, _react.useEffect)(() => {
    if (shouldReset && !prevShouldResetRef.current && selectedOptions.length > 0) {
      setSelectedOptions([]);
      setSearchValue('');
      onChange('');
    }
    prevShouldResetRef.current = shouldReset;
  }, [shouldReset, onChange, selectedOptions.length]);
  (0, _react.useEffect)(() => {
    if (defaultValue) {
      setSelectedOptions([{
        label: defaultValue,
        value: defaultValue
      }]);
    } else {
      setSelectedOptions([]);
    }
  }, [defaultValue]);
  const handleChange = (0, _react.useCallback)(changedOptions => {
    setSelectedOptions(changedOptions);
    if (changedOptions.length === 0) {
      onChange('');
    }
    if (changedOptions.length === 1) {
      onChange(changedOptions[0].value ? changedOptions[0].value.trim() : changedOptions[0].value);
    }
  }, [onChange]);
  const handleCreateOption = (0, _react.useCallback)(value => {
    handleChange([{
      label: value,
      value
    }]);
  }, [handleChange]);
  const terms = (_data$terms = data === null || data === void 0 ? void 0 : data.terms) !== null && _data$terms !== void 0 ? _data$terms : [];
  const options = [...(customOptions ? customOptions : []), ...terms.map(name => {
    return {
      label: name,
      value: name
    };
  })];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.apm.suggestionsSelect.comboBox.ariaLabel', {
      defaultMessage: 'Select a value'
    }),
    async: true,
    customOptionText: customOptionText,
    isClearable: isClearable,
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    onChange: handleChange,
    onSearchChange: (0, _lodash.throttle)(setSearchValue, 500),
    options: options,
    placeholder: placeholder,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    isInvalid: isInvalid,
    css: {
      minWidth: '256px'
    },
    onCreateOption: handleCreateOption,
    "data-test-subj": dataTestSubj,
    prepend: prepend,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  });
}