"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloCallout = SloCallout;
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-plugin/common");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/slo_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloCallout({
  dismissCallout,
  serviceName,
  environment,
  transactionType,
  transactionName
}) {
  const {
    plugins: {
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const locator = locators.get(_common.sloEditLocatorID);
  const handleClick = () => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      indicator: {
        type: 'sli.apm.transactionErrorRate',
        params: {
          service: serviceName,
          environment: environment === _environment_filter_values.ENVIRONMENT_ALL.value ? '*' : environment,
          transactionName,
          transactionType
        }
      }
    }, {
      replace: false
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.slo.callout.title', {
      defaultMessage: 'Respond quicker with SLOs'
    }),
    iconType: "lock",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.slo.callout.description",
    defaultMessage: "Keep your service's performance, speed, and user experience high with a Service Level Objective (SLO).",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSloCalloutCreateSloButton",
    onClick: () => {
      handleClick();
      dismissCallout();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.slo.callout.createButton', {
    defaultMessage: 'Create SLO'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmSloDismissButton",
    onClick: () => {
      dismissCallout();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.slo.callout.dimissButton', {
    defaultMessage: 'Hide this'
  })))))));
}