"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupInstructionsLink = SetupInstructionsLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/setup_instructions_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SETUP_INSTRUCTIONS_LABEL = _i18n.i18n.translate('xpack.apm.setupInstructionsButtonLabel', {
  defaultMessage: 'Setup instructions'
});
const ADD_DATA_LABEL = _i18n.i18n.translate('xpack.apm.addDataButtonLabel', {
  defaultMessage: 'Add data'
});

// renders a filled button or a link as a kibana link to setup instructions
function SetupInstructionsLink({
  buttonFill = false
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmSetupInstructionsLinkLink",
    href: core.http.basePath.prepend('/app/apm/tutorial'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, buttonFill ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSetupInstructionsLinkButton",
    size: "s",
    color: "primary",
    fill: buttonFill,
    iconType: "question",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }, SETUP_INSTRUCTIONS_LABEL) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmSetupInstructionsLinkButton",
    size: "s",
    color: "primary",
    iconType: "indexOpen",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, ADD_DATA_LABEL));
}