"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupsListItems = ServiceGroupsListItems;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_default_environment = require("../../../../hooks/use_default_environment");
var _service_group_card = require("./service_group_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_groups/service_groups_list/service_groups_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ServiceGroupsListItems({
  items,
  serviceGroupCounts,
  isLoading
}) {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/service-groups');
  const environment = (0, _use_default_environment.useDefaultEnvironment)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, items.map(item => /*#__PURE__*/_react.default.createElement(_service_group_card.ServiceGroupsCard, {
    key: item.id,
    serviceGroup: item,
    serviceGroupCounts: serviceGroupCounts[item.id],
    href: router.link('/services', {
      query: {
        ...query,
        serviceGroup: item.id,
        environment,
        kuery: ''
      }
    }),
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  })));
}